/***************************************************************************
                          standardtext.cpp  -  description
                             -------------------
    copyright            : (C) 2003 by Scott Wheeler
    email                : wheeler@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ktextedit.h>

#include <tqlabel.h>

#include "standardtext.h"

StandardText::StandardText(TQWidget *parent, const char *name, bool modal, WFlags fl) : StandardTextBase(parent, name, modal, fl)
{

}

StandardText::~StandardText()
{

}

void StandardText::setLabel(const TQString &text)
{
    label->setText(text);
}

void StandardText::setText(const TQString &text)
{
    textEdit->setText(text);
}

void StandardText::done(int r)
{
    if(r == TQDialog::Accepted)
	emit textUpdated(textEdit->text());
 
    StandardTextBase::done(r);
}

#include "standardtext.moc"
