/* This file is part of the KDE project
   Copyright (C) 2003 Fabian Wolf <fabianw@gmx.net>

   image_plugin.cpp (also Part of the KDE Project) used as template

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; version 2
   of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include <kgenericfactory.h>
#include <renamedlgplugin.h>
#include <tdeio/renamedlg.h>
#include <tqlabel.h>
#include <tqdialog.h>
#include <tqwidget.h>
#include <tqstringlist.h>
#include <tdeio/global.h>
#include <tqlayout.h>

#include <sys/types.h>

#include "audiopreview.h"

class AudioPlugin : public RenameDlgPlugin{
public:
  AudioPlugin( TQDialog *dialog, const char *name, const TQStringList & );
  ~AudioPlugin();
  virtual bool initialize( TDEIO::RenameDlg_Mode /*mod*/, const TQString &/*_src*/, const TQString &/*_dest*/,
		  const TQString &/*mimeSrc*/,
		  const TQString &/*mimeDest*/,
		  TDEIO::filesize_t /*sizeSrc*/,
		  TDEIO::filesize_t /*sizeDest*/,
		  time_t /*ctimeSrc*/,
		  time_t /*ctimeDest*/,
		  time_t /*mtimeSrc*/,
		  time_t /*mtimeDest*/ );
};

AudioPlugin::AudioPlugin( TQDialog *dialog, const char *name, const TQStringList &list ) : RenameDlgPlugin( dialog, name, list) {
  tqWarning("loaded" );  
}
AudioPlugin::~AudioPlugin()
{
}
bool AudioPlugin::initialize( TDEIO::RenameDlg_Mode mode, const TQString &_src, const TQString &_dest,
		  const TQString &mimeSrc,
		  const TQString &mimeDest,
		  TDEIO::filesize_t /*sizeSrc*/,
		  TDEIO::filesize_t /*sizeDest*/,
		  time_t /*ctimeSrc*/,
		  time_t /*ctimeDest*/,
		  time_t mtimeSrc,
		  time_t mtimeDest ) {
 TQGridLayout *lay = new TQGridLayout(this, 4, 3, 5);
 if( mode & TDEIO::M_OVERWRITE ){
   TQLabel *label_head = new TQLabel(this);
   TQLabel *label_src  = new TQLabel(this);
   TQLabel *label_dst  = new TQLabel(this);
   TQLabel *label_ask  = new TQLabel(this);

   TQString sentence1;
   TQString dest = KURL::fromPathOrURL(_dest).pathOrURL();
   if (mtimeDest < mtimeSrc)
      sentence1 = i18n("An older file named '%1' already exists.\n").arg(dest);
   else if (mtimeDest == mtimeSrc)
      sentence1 = i18n("A similar file named '%1' already exists.\n").arg(dest);
   else
      sentence1 = i18n("A newer file named '%1' already exists.\n").arg(dest);
   label_head->setText(sentence1);
   label_src->setText(i18n("Source File"));
   label_dst->setText(i18n("Existing File"));
   label_ask->setText(i18n("Would you like to replace the existing file with the one on the right?") );
   label_head->adjustSize();
   label_src->adjustSize();
   label_dst->adjustSize();
   label_ask->adjustSize();
   lay->addMultiCellWidget(label_head, 0, 0, 0, 2, TQt::AlignLeft);
   lay->addWidget(label_dst, 1, 0, TQt::AlignLeft);
   lay->addWidget(label_src, 1, 2, TQt::AlignLeft);
   lay->addMultiCellWidget(label_ask, 3, 3, 0, 2,  TQt::AlignLeft);
   adjustSize();
 }
 AudioPreview *left= new AudioPreview(this, "Preview Left", _dest, mimeDest );
 AudioPreview *right = new AudioPreview( this, "Preview Right", _src, mimeSrc);
 lay->addWidget(left, 2, 0 );
 lay->addWidget(right, 2, 2 );
 adjustSize();
 return true;
}

typedef KGenericFactory<AudioPlugin, TQDialog> AudioPluginFactory;
K_EXPORT_COMPONENT_FACTORY( librenaudioplugin, AudioPluginFactory("audiorename_plugin") )
