/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/
import org.trinitydesktop.qt.*;
import java.util.Calendar;

class Biff extends TQWidget
{
private    Calendar	lastModified;
private    TQPixmap	hasNewMail = new TQPixmap();
private    TQPixmap	noNewMail = new TQPixmap();
private    String	mailbox;
private    boolean	gotMail;

public Biff(  )
{
	this(null, null);
}
public Biff( TQWidget parent, String name )
{
    super( parent, name, WType_Modal );
//    TQFileInfo fi = new TQFileInfo(System.getProperty("MAIL"));
    TQFileInfo fi = new TQFileInfo("");
    if ( !fi.exists() ) {
	String s = "/var/spool/mail/";
	s += System.getProperty("user.name");
	fi.setFile( s );
    }
    if ( fi.exists() ) {
	mailbox = fi.absFilePath();
	startTimer( 1000 );
    }

    setMinimumSize( 48, 48 );
    setMaximumSize( 48, 48 );
    resize( 48, 48 );

    hasNewMail.loadFromData( bmp.hasmail_bmp_data );
    noNewMail.loadFromData( bmp.nomail_bmp_data );

    gotMail = false;
    lastModified = fi.lastModified();
}


protected void timerEvent( TQTimerEvent event )
{
    TQFileInfo fi = new TQFileInfo( mailbox );
    boolean newState = ( fi.lastModified() != lastModified &&
		      fi.lastModified().after( fi.lastRead() ) );
    if ( newState != gotMail ) {
	if ( gotMail )
	    lastModified = fi.lastModified();
	gotMail = newState;
	repaint( false );
    }
}
    

protected void paintEvent( TQPaintEvent event )
{
    if ( gotMail )
	bitBlt( this, 0, 0, hasNewMail );
    else
	bitBlt( this, 0, 0, noNewMail );
}


protected void mousePressEvent( TQMouseEvent event  )
{
    TQFileInfo fi = new TQFileInfo( mailbox );
    lastModified = fi.lastModified();
}
}
