import java.util.*;

import org.trinitydesktop.qt.*;
import org.trinitydesktop.koala.*;

/**	KScribbleDoc provides a document object for a document-view model.
  *
  * The KScribbleDoc class provides a document object that can be used in conjunction with the classes JavaApiTestApp and KScribbleView
  * to create a document-view model for standard KDE applications based on TDEApplication and TDEMainWindow. Thereby, the document object
  * is created by the JavaApiTestApp instance and contains the document structure with the according methods for manipulation of the document
  * data by KScribbleView objects. Also, KScribbleDoc contains the methods for serialization of the document data from and to files.
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.2 code generation
  */
public class KScribbleDoc extends TQObject {

    /** the list of the views currently connected to the document */
   private ArrayList pViewList;
   private String m_title;
   private String m_filename;
   private TQSize size;
   private TQPen pen;
   public TQPointArray polyline;
   public KPixmap buffer;

	/** the modified flag of the current document */
   private boolean modified;
   private KURL doc_url;


   public KScribbleDoc() {

      pViewList = new ArrayList();
   }

   void addView(KScribbleView view) {
      pViewList.add(view);
	   changedViewList();
   }

   void removeView(KScribbleView view) {
        pViewList.remove(view);
        if(!pViewList.isEmpty())
            changedViewList();
         else
            deleteContents();
   }

   void changedViewList(){

      KScribbleView w;
      if(pViewList.size() == 1){
         w=(KScribbleView)pViewList.get(0);
         w.setCaption(m_title);
      }
      else{
         int i = 1;
         Iterator it = pViewList.iterator();
         while(it.hasNext()) {
            w = (KScribbleView)it.next();
            w.setCaption(m_title + ":"+ i++);

         }
      }
   }

   boolean isLastView() {
     return (pViewList.size() == 1);
   }


   void updateAllViews(KScribbleView sender) {
      KScribbleView w;
      Iterator it = pViewList.iterator();
      while(it.hasNext()) {
         w = (KScribbleView)it.next();
         w.update(sender);

      }

   }

   void setPathName(String name) {
      m_filename=name;
      m_title= new TQFileInfo(name).fileName();
   }

   String pathName() {
      return m_filename;
   }

   /** returns the current pen in use */
   TQPen currentPen() {
      return pen;
   }

   /** returns the pen color */
	int penWidth() {
      return pen.width();
   }

   /** returns the pen color */
   TQColor penColor(){
      return pen.color();
   }

   /** sets the pen width */
   void setPenWidth( int w ){
      pen.setWidth( w );
   }

	/** sets the pen color */
  	void setPenColor( TQColor c ){
      pen.setColor( c );
   }

   /** sets the pen style by a second toolbar */
//   void setPenStyle( PenStyle s) {
//      pen.setStyle(s);
//   }

   void setTitle(String title) {

     m_title=title;
   }

   String title()  {
     return m_title;
   }

  /** sets the pixmap contents. Used by KScribbleApp
    to create a new document by drop events */
   void setPixmap(KPixmap pix) {
      buffer=pix;
   };
   void resizeDocument(TQSize m_size) {
      size=m_size;
   };

   void closeDocument() {
      KScribbleView w;
      if(!isLastView()) {
         Iterator it = pViewList.iterator();
         while(it.hasNext()) {
            w = (KScribbleView)it.next();
            if (!w.close())
               break;

         }

      }
      if(isLastView()) {
         w= (KScribbleView)pViewList.get(0);
         w.close();
      }
   }

   boolean newDocument() {
     /////////////////////////////////////////////////
     // TODO: Add your document initialization code here
     size=new TQSize(300,200 );
     pen= new TQPen();
     pen.setColor(Qt.black());
     pen.setWidth(3);
     polyline= new TQPointArray(3);
     if (buffer == null) {
      buffer = new KPixmap();
     }
     buffer.resize(size);
     buffer.fill( Qt.white() );
     /////////////////////////////////////////////////
     modified=false;
     return true;
   }

   public boolean openDocument(String filename, String format) {

      TQFile f = new TQFile( filename );
   //	if ( !f.open( IO_ReadOnly ) )
   //		return false;
     /////////////////////////////////////////////////
     // TODO: Add your document opening code here
      if(!buffer.load( filename, format, 0))
         return false;
      size=buffer.size();
     /////////////////////////////////////////////////
   //	f.close();

     modified=false;
     m_filename=filename;
      m_title=new TQFileInfo(f).fileName();
     return true;
   }

   boolean saveDocument(String filename) {
      return saveDocument(filename,"") ;
   }

    /** returns the first view instance */
   KScribbleView firstView(){
      return (KScribbleView) pViewList.get(0);
   };

   boolean saveDocument(String filename, String format /*=0*/) {
      TQFile f = new TQFile( filename );
      //	if ( !f.open( IO_WriteOnly ) )
      //		return false;

      /////////////////////////////////////////////////
      // TODO: Add your document saving code here
      if(!buffer.save( filename, format ))
         return false;
      /////////////////////////////////////////////////

      //  f.close();

      modified=false;
      m_filename=filename;
      m_title=new TQFileInfo(f).fileName();
      return true;
   }

   void deleteContents() {
     /////////////////////////////////////////////////
     // TODO: Add implementation to delete the document contents
     buffer.fill( Qt.white() );
     /////////////////////////////////////////////////

   }

   boolean isModified() {
      return modified;
   }

   void setModified() {
      modified = true;
   }

   boolean canCloseFrame(KScribbleView pFrame) {
      if(!isLastView())
         return true;

      boolean ret=false;
      if(isModified()) {
         String saveName = new String();
         switch(KMessageBox.warningYesNoCancel(pFrame, i18n("The current file has been modified.\n" +
                             "Do you want to save it?"),title()))
         {
            case KMessageBox.Yes:
               if(title().indexOf(i18n("Untitled")) > 0) {
                  saveName= KFileDialog.getSaveFileName(TQDir.currentDirPath(),
                         i18n("*|All files"), pFrame, i18n("Save as..."));
                  if(saveName == null || saveName.length() == 0)
                     return false;
                  }
                  else
                     saveName=pathName();

                  if(!saveDocument(saveName)) {
                     switch(KMessageBox.warningYesNo(pFrame,i18n("Could not save the current document !\n" +
                                                                                          "Close anyway ?"), i18n("I/O Error !")))
                     {
                        case KMessageBox.Yes:
                           ret=true;
                        case KMessageBox.No:
                           ret=false;
                     }
               }
               else
                  ret=true;
               break;
            case KMessageBox.No:
               ret=true;
               break;
            case KMessageBox.Cancel:
            default:
               ret=false;
               break;
         }
      }
      else
         ret=true;

      return ret;
   }

    /** get the document size */
   TQSize docSize() {
      return size;
   }

   void editClearAll() {
     deleteContents();
     setModified();
     updateAllViews(null);

   }

}
