import org.trinitydesktop.qt.*;
import org.trinitydesktop.koala.*;

/**
 *  Class KSimpleBrowser is the main application window.
 *
 *  Taken from KDE 2.0 Development book
 *
 *  Rendering HTML Files
 *
 *  A Simple Web Browser - A feature-limited Web Browser.
 *
 * @see TDEMainWindow
 * @see TDEApplication
 * @see TDEHTMLPart
 *
 * @author java translation Kenneth J. Pouncey, kjpou@hotmail.com
 * @version 0.1
 */

public class KSimpleBrowser extends TDEMainWindow {


   static final int URLLined = 1;

   TDEHTMLPart tdehtmlpart;

   public KSimpleBrowser (String name) {

      super(null,name,0);

      toolBar().insertLined( "", URLLined, TQ_SIGNAL("returnPressed()"),
               this, TQ_SLOT ("slotNewURL()"));


      toolBar().setItemAutoSized(URLLined);

      tdehtmlpart = new TDEHTMLPart(this);
      tdehtmlpart.begin();

      tdehtmlpart.write("<HTML><BODY><H1>KSimpleBrowser</H1>" +
                        "<P>To load a web page, type its URL in the line " +
                        "edit box and press enter,</P>" +
                        "</BODY></HTML>");

      tdehtmlpart.end();

      setCaption("KDE 2 Development book example - KSimpleBrowser");

      setCentralWidget(tdehtmlpart.view());

   }

   public void slotNewURL () {

      tdehtmlpart.openURL(new KURL(this.toolBar().getLinedText(URLLined)))   ;
   }


   static {
      qtjava.initialize();
      tdejava.initialize();
   }

}
