/***************************************************************************

                    query dialog for verbs

    -----------------------------------------------------------------------

    begin          : Fri Dec 3 18:28:18 1999

    copyright      : (C) 1999-2001 Ewald Arnold <kvoctrain@ewald-arnold.de>
                     (C) 2001 The KDE-EDU team
                     (C) 2005 Peter Hedlund <peter.hedlund@kdemail.net>

    -----------------------------------------------------------------------

 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef VerbQueryDlg_included
#define VerbQueryDlg_included

#include "VerbQueryDlgForm.h"
#include "QueryDlgBase.h"

class VerbQueryDlg : public QueryDlgBase
{
  TQ_OBJECT
  

public:

  VerbQueryDlg(
                TQString type,
                int entry,
                int col,
                int query_cycle,
                int query_num,
                int query_startnum,
                kvoctrainExpr *exp,
                kvoctrainDoc  *doc,
                const Conjugation &prefix,
                const Conjugation &conjug);

  ~VerbQueryDlg();

  void setQuery(TQString type,
                int entry,
                int col,
                int query_cycle,
                int query_num,
                int query_startnum,
                kvoctrainExpr *exp,
                kvoctrainDoc  *doc,
                const Conjugation &prefix,
                const Conjugation &conjug);

public slots:
  virtual void initFocus() const;

protected:
  bool next();
  void keyPressEvent( TQKeyEvent *e );
  void resetAllFields();

protected slots:
  void slotUser2();
  void slotP3pfChanged(const TQString&);
  void slotP3snChanged(const TQString&);
  void showAllClicked();
  void slotReturnPressed();
  void slotP3smChanged(const TQString&);
  void knowItClicked();
  void dontKnowClicked();
  void slotP3pnChanged(const TQString&);
  void slotP3sfChanged(const TQString&);
  void slotP1sChanged(const TQString&);
  void slotP2sChanged(const TQString&);
  void slotP3pmChanged(const TQString&);
  void slotP1pChanged(const TQString&);
  void slotP2pChanged(const TQString&);
  void verifyClicked();
  void timeoutReached();

protected:
  int current;
  Conjugation conjugations;
  bool all_known;

private:
  VerbQueryDlgForm * mw;
};

#endif // VerbQueryDlg_included
