/**
 * Copyright Michel Filippi <mfilippi@sade.rhein-main.de>
 *           Robert Williams
 *           Andrew Chant <andrew.chant@utoronto.ca>
 *           André Luiz dos Santos <andre@netvision.com.br>
 *           Benjamin Meyer <ben+ksnake@meyerhome.net>
 *
 * This file is part of the ksnake package
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
#include "startroom.h"

#include <tqlabel.h>
#include <tqpixmap.h>
#include <tqwmatrix.h>
#include <tqspinbox.h>
#include <tdelocale.h>
#include <tqlayout.h>

#include "levels.h"

StartRoom::StartRoom( TQWidget *parent, const char *name)
    : TQWidget( parent, name )
{
    TQGridLayout *Form1Layout = new TQGridLayout( this, 1, 1, 11, 6, "Form1Layout"); 
    TQSpacerItem* spacer = new TQSpacerItem( 20, 61, TQSizePolicy::Minimum, TQSizePolicy::Expanding );
    Form1Layout->addItem( spacer, 2, 1 );

    TQHBoxLayout *layout1 = new TQHBoxLayout( 0, 0, 6, "layout1"); 
    TQSpacerItem* spacer_2 = new TQSpacerItem( 91, 20, TQSizePolicy::Expanding, TQSizePolicy::Minimum );
    layout1->addItem( spacer_2 );

    picture = new TQLabel( this, "picture" );
    layout1->addWidget( picture );
    TQSpacerItem* spacer_3 = new TQSpacerItem( 41, 20, TQSizePolicy::Expanding, TQSizePolicy::Minimum );
    layout1->addItem( spacer_3 );

    Form1Layout->addMultiCellLayout( layout1, 0, 0, 0, 1 );

    roomRange = new TQSpinBox( this, "kcfg_StartingRoom" );
    roomRange->setMaxValue( 25 );
    roomRange->setMinValue( 1 );

    Form1Layout->addWidget( roomRange, 1, 1 );

    TQLabel *textLabel = new TQLabel( this, "textLabel" );
    textLabel->setText(i18n("First level:"));
    Form1Layout->addWidget( textLabel, 1, 0 );

    connect( roomRange, TQ_SIGNAL(valueChanged(int)), TQ_SLOT(loadLevel(int)));
    loadLevel(1);
}

void StartRoom::loadLevel(int level)
{
	if(level < 1 || level > leV->max())
		return;

	TQPixmap pixmap = leV->getPixmap(level);
	TQWMatrix m;
	m.scale( (double)7, (double)7 );
	pixmap = pixmap.xForm( m );
	picture->setPixmap(pixmap);
}

#include "startroom.moc"

