#include <tqlayout.h>
#include <tdeapplication.h>
#include <tdelocale.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>

#include "scoredlg.h"

ScoreDlgListViewItem::ScoreDlgListViewItem(TQListView *parent, TQString s1, TQString s2, TQString s3, TQString s4, TQString s5, TQString s6) : TQListViewItem(parent, s1, s2, s3, s4, s5, s6)
{
}

int ScoreDlgListViewItem::compare(TQListViewItem *i, int col, bool) const
{
	if (col == 0)
	{
		if (text(col) > i -> text(col)) return 1;
		else if (text(col) < i -> text(col)) return -1;
		else return 0;
	}
	else
	{
		if (text(col).toInt() > i -> text(col).toInt()) return 1;
		else if (text(col).toInt() < i -> text(col).toInt()) return -1;
		else return compare(i, 0, true);
	}
}


ScoreDlg::ScoreDlg( TQWidget *parent, const TQString& title, PlayerList *players )
    : TQDialog(parent, "ScoreDlg", true ), plrList(players)
{
    setCaption( kapp->makeStdCaption(title) );

    scoreTable = new TDEListView( this, 0 );
    scoreTable->addColumn(i18n("Player"));
    scoreTable->addColumn(i18n("Ships Built"));
    scoreTable->addColumn(i18n("Planets Conquered"));
    scoreTable->addColumn(i18n("Fleets Launched"));
    scoreTable->addColumn(i18n("Fleets Destroyed"));
    scoreTable->addColumn(i18n("Ships Destroyed"));
    scoreTable->setMinimumSize( scoreTable->sizeHint() );

    KPushButton *okButton = new KPushButton( KStdGuiItem::ok(), this );
    okButton->setMinimumSize( okButton->sizeHint() );
    okButton->setDefault(true);

    TQVBoxLayout *layout1 = new TQVBoxLayout( this );
    TQHBoxLayout *layout2 = new TQHBoxLayout;

    layout1->addWidget( scoreTable, 1 );
    layout1->addLayout( layout2 );

    layout2->addStretch( 2 );
    layout2->addWidget( okButton );
    layout2->addStretch( 2 );

    connect( okButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(accept()) );

    init();

    resize( 580, 140  );
}

void
ScoreDlg::init()
{
    Player *curPlayer;
    PlayerListIterator itr( *plrList );

    for( ;(curPlayer = itr()); )
        new ScoreDlgListViewItem(scoreTable,
                                 curPlayer->getName(),
                                 TQString("%1").arg(curPlayer->getShipsBuilt()),
                                 TQString("%1").arg(curPlayer->getPlanetsConquered()),
                                 TQString("%1").arg(curPlayer->getFleetsLaunched()),
                                 TQString("%1").arg(curPlayer->getEnemyFleetsDestroyed()),
                                 TQString("%1").arg(curPlayer->getEnemyShipsDestroyed()));
}

