/*
 * KMix -- KDE's full featured mini mixer
 *
 *
 * Copyright (C) 1996-2004 Christian Esken <esken@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <tdelocale.h>
#include <kled.h>
#include <kiconloader.h>
#include <tdeconfig.h>
#include <tdeaction.h>
#include <tdepopupmenu.h>
#include <kglobalaccel.h>
#include <kkeydialog.h>
#include <kdebug.h>

#include <tqobject.h>
#include <tqcursor.h>
#include <tqslider.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqpixmap.h>
#include <tqtooltip.h>
#include <tqwmatrix.h>

#include "mixer.h"
#include "mixdevicewidget.h"
#include "viewbase.h"
#include "kledbutton.h"
#include "ksmallslider.h"
#include "verticaltext.h"

/**
 * Class that represents a single mix device, inlcuding PopUp, muteLED, ...
 * Used in KMix main window and DockWidget and PanelApplet.
 * It can be configured to include or exclude the recordLED and the muteLED.
 * The direction (horizontal, vertical) can be configured and whether it should
 * be "small"  (uses KSmallSlider instead of TQSlider then).
 */
MixDeviceWidget::MixDeviceWidget(Mixer *mixer, MixDevice* md,
                                 bool small, TQt::Orientation orientation,
                                 TQWidget* parent, ViewBase* mw, const char* name) :
   TQWidget( parent, name ), m_mixer(mixer), m_mixdevice( md ), m_mixerwidget( mw ),
   m_disabled( false ), _orientation( orientation ), m_small( small )
{
   _mdwActions = new TDEActionCollection( this );
   m_keys = new TDEGlobalAccel( this, "Keys" );
}

MixDeviceWidget::~MixDeviceWidget()
{
}


void MixDeviceWidget::addActionToPopup( TDEAction *action )
{
	_mdwActions->insert( action );
}


bool MixDeviceWidget::isDisabled() const
{
   return m_disabled;
}


TDEGlobalAccel *MixDeviceWidget::keys( void )
{
    return m_keys;
}

void MixDeviceWidget::defineKeys()
{
   if (m_keys) {
      KKeyDialog::configure(m_keys, 0, false);
      // The keys are saved in KMixerWidget::saveConfig, see kmixerwidget.cpp
      m_keys->updateConnections();
   }
}

void MixDeviceWidget::volumeChange( int ) { /* is virtual */ }
void MixDeviceWidget::setDisabled( bool ) { /* is virtual */ }
void MixDeviceWidget::setVolume( int /*channel*/, int /*vol*/ ) { /* is virtual */ }
void MixDeviceWidget::setVolume( Volume /*vol*/ ) { /* is virtual */ }
void MixDeviceWidget::update() { /* is virtual */ }
void MixDeviceWidget::showContextMenu() { /* is virtual */ }
void MixDeviceWidget::setColors( TQColor , TQColor , TQColor ) { /* is virtual */ }
void MixDeviceWidget::setIcons( bool ) { /* is virtual */ }
void MixDeviceWidget::setLabeled( bool ) { /* is virtual */ }
void MixDeviceWidget::setMutedColors( TQColor , TQColor , TQColor ) { /* is virtual */ }




void MixDeviceWidget::mousePressEvent( TQMouseEvent *e )
{
   if ( e->button()==TQt::RightButton )
      showContextMenu();
   else {
       TQWidget::mousePressEvent(e);
   }
}


#include "mixdevicewidget.moc"
