/***************************************************************************
                          dictmanager.cpp  -  description
                             -------------------
    begin                : Wed Jan 1 2003
    copyright            : (C) 2003 by Jan Sch�fer
    email                : janschaefer@users.sourceforge.net
 ***************************************************************************/

/******************************************************************************
 *                                                                            *
 *  This file is part of KSambaPlugin.                                          *
 *                                                                            *
 *  KSambaPlugin is free software; you can redistribute it and/or modify            *
 *  it under the terms of the GNU General Public License as published by      *
 *  the Free Software Foundation; either version 2 of the License, or         *
 *  (at your option) any later version.                                       *
 *                                                                            *
 *  KSambaPlugin is distributed in the hope that it will be useful,                 *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *  GNU General Public License for more details.                              *
 *                                                                            *
 *  You should have received a copy of the GNU General Public License         *
 *  along with KSambaPlugin; if not, write to the Free Software                     *
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA  *
 *                                                                            *
 ******************************************************************************/
 
 
#include <tqlineedit.h>
#include <tqcheckbox.h>
#include <tqspinbox.h>
#include <tqcombobox.h>
#include <tqtooltip.h>
#include <tqstringlist.h>

#include <kurlrequester.h> 
#include <tdelocale.h>
 
#include "sambashare.h"
#include "dictmanager.h" 
#include "common.h"

 
DictManager::DictManager(SambaShare* share):
  lineEditDict(40,false),
  checkBoxDict(40,false),
  urlRequesterDict(40,false),
  spinBoxDict(40,false),
  comboBoxDict(20,false),
  comboBoxValuesDict(20,false)
{
  _share = share;
}

DictManager::~DictManager() {
}

void DictManager::handleUnsupportedWidget(const TQString & s, TQWidget* w) {
  w->setEnabled(false);
  TQToolTip::add(w,i18n("The option <em>%1</em> is not supported by your Samba version").arg(s));
}

void DictManager::add(const TQString & key, TQLineEdit* lineEdit) {
  if (_share->optionSupported(key)) {
    lineEditDict.insert(key,lineEdit);
    connect(lineEdit, TQ_SIGNAL(textChanged(const TQString &)), this, TQ_SLOT(changedSlot()));
  } else
    handleUnsupportedWidget(key,lineEdit);
}

void DictManager::add(const TQString & key, TQCheckBox* checkBox){
  if (_share->optionSupported(key)) {
    checkBoxDict.insert(key,checkBox);
    connect(checkBox, TQ_SIGNAL(clicked()), this, TQ_SLOT(changedSlot()));
  } else
    handleUnsupportedWidget(key,checkBox);
}

void DictManager::add(const TQString & key, KURLRequester* urlRq){
  if (_share->optionSupported(key)) {
    urlRequesterDict.insert(key,urlRq);
    connect(urlRq, TQ_SIGNAL(textChanged(const TQString &)), this, TQ_SLOT(changedSlot()));
  } else
    handleUnsupportedWidget(key,urlRq);
}

void DictManager::add(const TQString & key, TQSpinBox* spinBox){
  if (_share->optionSupported(key)) {
    spinBoxDict.insert(key,spinBox);
    connect(spinBox, TQ_SIGNAL(valueChanged(int)), this, TQ_SLOT(changedSlot()));
  } else
    handleUnsupportedWidget(key,spinBox);
}
              
void DictManager::add(const TQString & key, TQComboBox* comboBox, TQStringList* values){
  if (_share->optionSupported(key)) {
    comboBoxDict.insert(key,comboBox);
    comboBoxValuesDict.insert(key,values);
    connect(comboBox, TQ_SIGNAL(activated(int)), this, TQ_SLOT(changedSlot()));
  } else
    handleUnsupportedWidget(key,comboBox);
}


void DictManager::load(SambaShare* share, bool globalValue, bool defaultValue){
  TQDictIterator<TQCheckBox> checkBoxIt( checkBoxDict ); 
   
  for( ; checkBoxIt.current(); ++checkBoxIt )	{
    checkBoxIt.current()->setChecked(share->getBoolValue(checkBoxIt.currentKey(),globalValue,defaultValue));
  }

  TQDictIterator<TQLineEdit> lineEditIt( lineEditDict ); 
 
  for( ; lineEditIt.current(); ++lineEditIt )	{
    lineEditIt.current()->setText(share->getValue(lineEditIt.currentKey(),globalValue,defaultValue));
  }

  TQDictIterator<KURLRequester> urlRequesterIt( urlRequesterDict ); 
 
  for( ; urlRequesterIt.current(); ++urlRequesterIt )	{
    urlRequesterIt.current()->setURL(share->getValue(urlRequesterIt.currentKey(),globalValue,defaultValue));
  }

  TQDictIterator<TQSpinBox> spinBoxIt( spinBoxDict ); 
   
  for( ; spinBoxIt.current(); ++spinBoxIt )	{
    spinBoxIt.current()->setValue(share->getValue(spinBoxIt.currentKey(),globalValue,defaultValue).toInt());
  }

  loadComboBoxes(share,globalValue,defaultValue);

}

void DictManager::loadComboBoxes(SambaShare* share, bool globalValue, bool defaultValue) {
  TQDictIterator<TQComboBox> comboBoxIt( comboBoxDict ); 
   
  for( ; comboBoxIt.current(); ++comboBoxIt )	{
    TQStringList *v = comboBoxValuesDict[comboBoxIt.currentKey()];
    TQString value = share->getValue(comboBoxIt.currentKey(),globalValue,defaultValue);

    if (value.isNull())
        continue;
        
    value = value.lower();

    
    int comboIndex = 0;
                                
    TQStringList::iterator it;
    for ( it = v->begin(); it != v->end(); ++it ) {
      TQString lower = (*it).lower();      
      if ( lower == "yes" &&
           boolFromText(value))
           break;

      if ( lower == "no" &&
           ! boolFromText(value,false))
           break;

      if ( lower == value ) 
           break;                            
      
      comboIndex++;
    }

    if (comboIndex < comboBoxIt.current()->count()) {
      comboBoxIt.current()->setCurrentItem(comboIndex);
    }
  }
}


void DictManager::save(SambaShare* share, bool globalValue, bool defaultValue){
  TQDictIterator<TQCheckBox> checkBoxIt( checkBoxDict ); 
 
  for( ; checkBoxIt.current(); ++checkBoxIt )	{
    share->setValue(checkBoxIt.currentKey(),checkBoxIt.current()->isChecked(), globalValue, defaultValue );
  }

  TQDictIterator<TQLineEdit> lineEditIt( lineEditDict ); 
   
  for( ; lineEditIt.current(); ++lineEditIt )	{
    share->setValue(lineEditIt.currentKey(),lineEditIt.current()->text(), globalValue, defaultValue );
  }

  TQDictIterator<KURLRequester> urlRequesterIt( urlRequesterDict ); 
 
  for( ; urlRequesterIt.current(); ++urlRequesterIt )	{
    share->setValue(urlRequesterIt.currentKey(),urlRequesterIt.current()->url(), globalValue, defaultValue );
  }

  TQDictIterator<TQSpinBox> spinBoxIt( spinBoxDict ); 
 
  for( ; spinBoxIt.current(); ++spinBoxIt )	{
    share->setValue(spinBoxIt.currentKey(),spinBoxIt.current()->value(), globalValue, defaultValue );
  }

  TQDictIterator<TQComboBox> comboBoxIt( comboBoxDict );
  
  for( ; comboBoxIt.current(); ++comboBoxIt )	{
    TQStringList* values = comboBoxValuesDict[comboBoxIt.currentKey()];
    
    int i = comboBoxIt.current()->currentItem();
    share->setValue(comboBoxIt.currentKey(),(*values)[i], globalValue, defaultValue );
  }
    
}

void DictManager::changedSlot() {
  emit changed();
}



#include "dictmanager.moc"


