/*
    p2p.h - msn p2p protocol

    Copyright (c) 2003-2005 by Olivier Goffart        <ogoffart@ kde.org>
    Copyright (c) 2005      by Gregg Edghill          <gregg.edghill@gmail.com>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef P2P_H
#define P2P_H

// TQt includes
#include <tqobject.h>
#include "messageformatter.h"

#include "kopete_export.h"

#include "config.h"

namespace Kopete { class Transfer; }
namespace Kopete { struct FileTransferInfo; }
namespace P2P { class Dispatcher; }
namespace KNetwork { class TDEBufferedSocket; }
class TQFile;
class KTempFile;

/**
@author Kopete Developers
*/
namespace System{
	class Guid
	{
		public:
			~Guid(){}
			static Guid newGuid();
			TQString toString();

		private:
			Guid(){}
	};
}

namespace P2P{

	enum TransferType { UserDisplayIcon = 1, File = 2, WebcamType=4};
	enum TransferDirection { Incoming = 1, Outgoing = 8};
	enum MessageType { BYE, OK, DECLINE, ERROR, INVITE };

	enum CommunicationState
	{
		Invitation   = 1,
		Negotiation  = 2,
		DataTransfer = 8,
		Finished     = 16
	};

	struct TransportHeader
	{
		TQ_UINT32 sessionId;
		TQ_UINT32 identifier;
		TQ_INT64  dataOffset;
		TQ_INT64  totalDataSize;
		TQ_UINT32 dataSize;
		TQ_UINT32 flag;
		TQ_UINT32 ackSessionIdentifier;
		TQ_UINT32 ackUniqueIdentifier;
		TQ_INT64  ackDataSize;
	};

	struct Message
	{
		public:
			TQString mimeVersion;
			TQString contentType;
			TQString destination;
			TQString source;
			TransportHeader header;
			TQByteArray body;
			TQ_INT32 applicationIdentifier;
			bool attachApplicationIdentifier;
	};

	class KOPETE_EXPORT Uid
	{
		public: static TQString createUid();
	};

	class KOPETE_EXPORT TransferContext : public TQObject
	{	TQ_OBJECT
  
		public:
			virtual ~TransferContext();

			void acknowledge(const Message& message);
			virtual void acknowledged() = 0;
			void error();
			virtual void processMessage(const P2P::Message& message) = 0;
			void sendDataPreparation();
			void sendMessage(MessageType type, const TQString& content=TQString(), TQ_INT32 flag=0, TQ_INT32 appId=0);
			void setType(TransferType type);

		public:
			TQ_UINT32 m_sessionId;
			TQ_UINT32 m_identifier;
			TQFile   *m_file;
			TQ_UINT32 m_transactionId;
			TQ_UINT32 m_ackSessionIdentifier;
			TQ_UINT32 m_ackUniqueIdentifier;
			Kopete::Transfer *m_transfer;
			TQString  m_branch;
			TQString  m_callId;
			TQString  m_object;


		public slots:
			void abort();
			void readyWrite();

		protected:
			TransferContext(const TQString& contact, P2P::Dispatcher *dispatcher,TQ_UINT32 sessionId);
			void sendData(const TQByteArray& bytes);
			void sendMessage(P2P::Message& outbound, const TQByteArray& body);
			virtual void readyToSend();

			TQ_UINT32 m_baseIdentifier;
			TransferDirection m_direction;
			P2P::Dispatcher *m_dispatcher;
			bool m_isComplete;
			TQ_INT64 m_offset;
			TQ_INT64 m_totalDataSize;
			P2P::MessageFormatter m_messageFormatter;
			TQString m_recipient;
			TQString m_sender;
			KNetwork::TDEBufferedSocket *m_socket;
   			CommunicationState m_state;
   			TransferType m_type;
	};
}

#endif
