/*
    yahoowebcam.h - Send webcam images

    Copyright (c) 2005 by André Duffec <andre.duffeck@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef YAHOOWEBCAM_H
#define YAHOOWEBCAM_H

#include <tqobject.h>
#include <tqstringlist.h>

class YahooAccount;
class YahooWebcamDialog;
class TQTimer;
class TQImage;
class KTempFile;

namespace Kopete { 
	namespace AV	{
		class VideoDevicePool;
	}
}

class YahooWebcam : public TQObject
{	
	TQ_OBJECT
  
public:
	YahooWebcam( YahooAccount *account );
	~YahooWebcam();
public slots:
	void startTransmission();
	void stopTransmission();
	void sendImage();
	void updateImage();
	void webcamDialogClosing();
	void addViewer( const TQString & );
	void removeViewer( const TQString & );
signals:
	void webcamClosing();
private:
	YahooAccount *theAccount;
	YahooWebcamDialog *theDialog;
	TQTimer *m_sendTimer;
	TQTimer *m_updateTimer;
	TQStringList m_viewer;
	TQImage *m_img;
	KTempFile *origImg;
	KTempFile *convertedImg;
	Kopete::AV::VideoDevicePool *m_devicePool;
};

#endif
