/* $Id$ */

#include <kuniqueapplication.h>
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <kdebug.h>
#include <tdeaboutdata.h>
#include <tdelocale.h>
#include <dcopclient.h>
#include "service.h"
#include "query.h"

int main (int argc, char *argv[])
{
	TDELocale::setMainCatalogue("dcoprss");
	TDEAboutData aboutdata("rssservice", I18N_NOOP("TDE RSS Service"),
				"0.8", I18N_NOOP("A RSS data service."),
				TDEAboutData::License_GPL, "(C) 2003, Ian Reinhart Geiser");
	aboutdata.addAuthor("Ian Reinhart Geiser",I18N_NOOP("Developer"),"geiseri@kde.org");

	TDECmdLineArgs::init( argc, argv, &aboutdata );
	// TDECmdLineArgs::addCmdLineOptions( options );
	KUniqueApplication::addCmdLineOptions();

	if (!KUniqueApplication::start())
	{
		kdDebug() << "rssservice is already running!" << endl;
		return (0);
	}

	KUniqueApplication app;
	kdDebug() << "starting rssservice " << endl;
	// This app is started automatically, no need for session management
	app.disableSessionManagement();
	RSSService *service = new RSSService;
	QueryService *query = new QueryService(service);

	return app.exec();
}
