/****************************************************************************
** $Id$
**
** Copyright (C) 2002 Carsten Pfeiffer <pfeiffer@kde.org>
**
****************************************************************************/

#ifndef KGET_LINKVIEW_H
#define KGET_LINKVIEW_H

#include <tqptrlist.h>

#include <tdelistview.h>
#include <tdemainwindow.h>
#include <kurl.h>

#include "links.h"

class LinkViewItem : public TQListViewItem
{
public:
    LinkViewItem( TQListView *parent, const LinkItem * lnk );
    const LinkItem *link;
};


class KGetLinkView : public TDEMainWindow
{
    TQ_OBJECT
  

public:
    KGetLinkView( TQWidget *parent = 0L, const char *name = 0L );
    ~KGetLinkView();

    void setLinks( TQPtrList<LinkItem>& links );
    void setPageURL( const TQString& url );

signals:
    void leechURLs( const KURL::List& urls );

private slots:
    void slotStartLeech();
    void slotSelectAll();

private:
    void showLinks( const TQPtrList<LinkItem>& links );

    TQPtrList<LinkItem> m_links;

    TDEListView *m_view;

};

#endif // KGET_LINKVIEW_H
