/*
    dispatcher.h - msn p2p protocol

    Copyright (c) 2003-2005 by Olivier Goffart        <ogoffart@ kde.org>
    Copyright (c) 2005      by Gregg Edghill          <gregg.edghill@gmail.com>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef DISPATCHER_H
#define DISPATCHER_H

#include <tqobject.h>
#include <tqstringlist.h>

#include "kopete_export.h"

#include "p2p.h"
#include "messageformatter.h"
#include "incomingtransfer.h"
#include "outgoingtransfer.h"


namespace Kopete { class Contact; }
class MSNSwitchBoardSocket;

/**
@author Kopete Developers
*/
namespace P2P{
	class IncomingTransfer;
	class OutgoingTransfer;

	class KOPETE_EXPORT Dispatcher : public TQObject
	{	TQ_OBJECT
  
		public:
			Dispatcher(TQObject *parent, const TQString& contact, const TQStringList &ip);
			~Dispatcher();

			void detach(TransferContext* transfer);
			TQString localContact();
			void requestDisplayIcon(const TQString& from, const TQString& msnObject);
			void sendFile(const TQString& path, TQ_INT64 fileSize, const TQString& to);
			void sendImage(const TQString& fileName, const TQString& to);
			TQString m_pictureUrl;
			TQMap<TQString, TQString> objectList;

#if MSN_WEBCAM
			void startWebcam(const TQString &myHandle, const TQString &msgHandle, bool wantToReceive);
#endif


		public slots:
			void slotReadMessage(const TQString &from, const TQByteArray& stream);
			void messageAcknowledged(unsigned int correlationId, bool fullReceive);

		signals:
			void sendCommand(const TQString &cmd, const TQString &args = TQString(), bool addId = true, const TQByteArray &body = TQByteArray(), bool binary=false);
			void displayIconReceived(KTempFile* file, const TQString& msnObject);
			void incomingTransfer(const TQString& from, const TQString& fileName, TQ_INT64 fileSize);

		private:
				class CallbackChannel
				{
					public:
						CallbackChannel(MSNSwitchBoardSocket *switchboard);
						~CallbackChannel();

						TQ_UINT32 send(const TQByteArray& stream);

					private:
						MSNSwitchBoardSocket *m_switchboard;
				};

		public:
			CallbackChannel* callbackChannel();
			/**
			 * IP's of this compiter,  the first one is the one seen by the server.
			 */
			TQStringList localIp() { return m_ip; }


		private:
			void dispatch(const P2P::Message& message);
			Kopete::Contact* getContactByAccountId(const TQString& accountId);

			P2P::MessageFormatter m_messageFormatter;
			TQMap<TQ_UINT32, P2P::TransferContext*> m_sessions;
			TQMap<TQ_UINT32, P2P::Message> m_messageBuffer;
			TQString m_contact;
			CallbackChannel *m_callbackChannel;
			TQStringList m_ip;

			friend class P2P::TransferContext;
			friend class P2P::IncomingTransfer;
			friend class P2P::OutgoingTransfer;
	};
}

#endif
