/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** TQt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/


void GroupSelectDlg::init(const TQStringList & specifiedGroups)
{
  TQStringList unixGroups = getUnixGroups();

  for (TQStringList::Iterator it = unixGroups.begin(); it != unixGroups.end(); ++it)
  {
      if ( ! specifiedGroups.contains(*it))
	  new TQListViewItem(groupListView, *it, TQString::number(getGroupGID(*it)));
  }
}

void GroupSelectDlg::accept()
{
  TQListViewItemIterator it( groupListView);

  for ( ; it.current(); ++it ) {
      if ( it.current()->isSelected() )
	  selectedGroups << it.current()->text(0);
  }	
  
  access = accessBtnGrp->id(accessBtnGrp->selected());
  
  if (unixRadio->isChecked())
      groupKind = "+";
  else
      if (nisRadio->isChecked())
	  groupKind = "&";
  else
      if (bothRadio->isChecked())
	  groupKind = "@";
  
  TQDialog::accept();
}




TQStringList GroupSelectDlg::getSelectedGroups()
{
    return selectedGroups;
}


int GroupSelectDlg::getAccess()
{
    return access;
}


TQString GroupSelectDlg::getGroupKind()
{
    return groupKind;
}
