/***************************************************************************
 *
 * tdenetman-menuitem.cpp - A NetworkManager frontend for TDE
 *
 * Copyright (C) 2005, 2006, 2008 Novell, Inc.
 *
 * Author: Timo Hoenig        <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson    <wstephenson@suse.de>, <wstephenson@kde.org>
 *         Valentine Sinitsyn <e_val@inbox.ru>
 *         Helmut Schaa       <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include "tdenetman-menuitem.h"

#include <tqevent.h>
#include <tqguardedptr.h>
#include <tqvbox.h>
#include <tqlayout.h>
#include <tqpushbutton.h>
#include <tqpixmap.h>
#include <tqpixmapcache.h>
#include <tqpainter.h>
#include <tqstyle.h>
#include <dcopclient.h>
#include <kdebug.h>
#include <kdialogbase.h>
#include <knotifyclient.h>
#include <knotifydialog.h>
#include <tdelocale.h>
#include <kstdguiitem.h>
#include <khelpmenu.h>
#include <kprocess.h>
#include <kiconloader.h>
#include <tdeconfig.h>
#include <tdemessagebox.h>

using namespace ConnectionSettings;

class NetworkMenuItemPrivate
{
	public:
		NetworkMenuItemPrivate(TQString device, TQString connection)
		: dev(device), conn(connection)
		{

		}
		~NetworkMenuItemPrivate() {}

		TQString dev;
		TQString conn;
};

void NetworkMenuItem::slotActivate()
{
	kdDebug() << "NetworkMenuItem::slotActivate()" << endl;

	TDEHardwareDevices* hwdevices = TDEGlobal::hardwareDevices();
	TDEGlobalNetworkManager* nm = TDEGlobal::networkManager();

	TDENetworkDevice* dev = dynamic_cast<TDENetworkDevice*>(hwdevices->findByUniqueID(d->dev));
	TDENetworkConnection* conn = (nm ? nm->findConnectionByUUID(d->conn) : 0);

	if (dev && conn)
	{
		TDENetworkConnectionManager* deviceConnMan = dev->connectionManager();
		if (deviceConnMan)
		{
			kdDebug() << "Activate Connection " << conn->UUID.ascii() << " on Device " << dev->deviceNode().ascii() << endl;
			printf("Activate Connection %s on Device %s\n", conn->UUID.ascii(), dev->deviceNode().ascii());

			TDENetworkConnectionStatus::TDENetworkConnectionStatus result = deviceConnMan->initiateConnection(conn->UUID);
// 			if ((result == TDENetworkConnectionStatus::Disconnected)
// 				|| (result == TDENetworkConnectionStatus::Invalid)) {
// 				//
// 			}
// 			else {
// 				kdDebug() << "ActivateDevice failed" << endl;
// 			}
		}
	}
	else if (conn)
	{
		// no device given, just take the default device
		printf("Activate Connection %s on default device\n", conn->UUID.ascii());

		TDENetworkConnectionStatus::TDENetworkConnectionStatus result = nm->initiateConnection(conn->UUID);
		if ((result == TDENetworkConnectionStatus::Disconnected)
			|| (result == TDENetworkConnectionStatus::Invalid)) {
			//
		}
		else {
			kdDebug() << "ActivateConnection failed" << endl;
		}
	}
	else
		kdDebug() << "Device or Connection invalid" << endl;
}

NetworkMenuItem::NetworkMenuItem (TQString dev, TQString conn, TQObject* parent, const char* name)
		       : TQObject(parent, name)
{
	d = new NetworkMenuItemPrivate(dev, conn);
}

NetworkMenuItem::~NetworkMenuItem ()
{
	delete d;
}



#include "tdenetman-menuitem.moc"
