/*
    This file is part of KMail.
    Copyright (c) 2002-2003 Don Sanders <sanders@kde.org>,
    Copyright (c) 2003      Zack Rusin  <zack@kde.org>,
    Based on the work of Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/
#ifndef KMail_PART_H
#define KMail_PART_H

#include "kmailpartIface.h"

#include <tdeversion.h>
#include <tdeparts/browserextension.h>
#include <tdeparts/statusbarextension.h>
#include <tdeparts/factory.h>
#include <tdeparts/event.h>
#include <tdeparts/part.h>

#include <tqwidget.h>
#include <tdemacros.h>

class TDEInstance;
class TDEAboutData;
class KMailStatusBarExtension;
class KMKernel;
class KMMainWidget;
namespace KPIM { class StatusbarProgressWidget; }
using KPIM::StatusbarProgressWidget;
class KMFolder;
class KMFolderTreeItem;

class ActionManager;

class TDE_EXPORT KMailPart: public KParts::ReadOnlyPart, virtual public KMailPartIface
{
    TQ_OBJECT
  
  public:
    KMailPart(TQWidget *parentWidget, const char *widgetName,
              TQObject *parent, const char *name, const TQStringList &);
    virtual ~KMailPart();

    TQWidget* parentWidget() const;

    static TDEAboutData *createAboutData();

  public slots:
    virtual void save() { /*TODO*/ }
    virtual void exit();
    virtual void updateEditMenu() {}
    void exportFolder( KMFolder* folder );
    void slotIconChanged( KMFolderTreeItem *fti );
    void slotNameChanged( KMFolderTreeItem *fti );

  signals:
    void textChanged( const TQString& );
    void iconChanged( const TQPixmap& );

  protected:
    virtual bool openFile();
    virtual void guiActivateEvent(KParts::GUIActivateEvent *e);

  private:
    KMKernel *mKMailKernel;
    KMMainWidget *mainWidget;
    ActionManager *mActionManager;
    KMailStatusBarExtension *mStatusBar;
    TQWidget *mParentWidget;
};

class KMailStatusBarExtension : public KParts::StatusBarExtension
{
public:
  KMailStatusBarExtension( KMailPart *parent );

  TDEMainWindow *mainWindow() const;

private:
  KMailPart *mParent;
  StatusbarProgressWidget *mLittleProgress;
};

#endif
