/*
    This file is part of tdepim.

    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef KODE_VARIABLE_H
#define KODE_VARIABLE_H

#include <tqvaluelist.h>
#include <tqstring.h>

#include <tdemacros.h>

namespace KODE {

class TDE_EXPORT Variable
{
  public:
    typedef TQValueList<Variable> List;

    Variable();
    Variable( const TQString &name, const TQString &type, bool isStatic = false );

    void setType( const TQString & );
    TQString type() const { return mType; }

    void setName( const TQString & );
    TQString name() const { return mName; }

    void setStatic( bool );
    bool isStatic() const { return mIsStatic; }

    void setInitializer( const TQString & );
    TQString initializer() const { return mInitializer; }

  private:
    TQString mType;
    TQString mName;
    bool mIsStatic;
    TQString mInitializer;
};

}

#endif
