/*
 *   This file is part of ScalixAdmin.
 *
 *   Copyright (C) 2007 Trolltech ASA. All rights reserved.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <tdeabc/ldapclient.h>
#include <tdelocale.h>
#include <tdemessagebox.h>

#include "settings.h"

#include "ldapview.h"

class LdapItem : public TQListViewItem
{
  public:
    LdapItem( TQListView *parent, const TQString &text, const TQString &email )
      : TQListViewItem( parent )
    {
      setText( 0, text );
      setText( 1, email );
    }
};


LdapView::LdapView( TQWidget *parent )
  : TDEListView( parent )
{
  addColumn( i18n( "User" ) );
  setFullWidth( true );

  mClient = new TDEABC::LdapClient;

  mClient->setHost( Settings::self()->ldapHost() );
  mClient->setPort( Settings::self()->ldapPort() );
  mClient->setBase( Settings::self()->ldapBase() );
  mClient->setBindDN( Settings::self()->ldapBindDn() );
  mClient->setPwdBindDN( Settings::self()->ldapPassword() );

  TQStringList attrs;
  attrs << "surname" << "mail";
  mClient->setAttrs( attrs );

  connect( mClient, TQ_SIGNAL( result( const TDEABC::LdapObject& ) ),
           this, TQ_SLOT( entryAdded( const TDEABC::LdapObject& ) ) );
  connect( mClient, TQ_SIGNAL( error( const TQString& ) ),
           this, TQ_SLOT( error( const TQString& ) ) );
}

LdapView::~LdapView()
{
  mClient->cancelQuery();
  delete mClient;
}

TQString LdapView::selectedUser() const
{
  TQListViewItem *item = selectedItem();
  if ( !item )
    return TQString();
  else
    return item->text( 1 );
}

void LdapView::setQuery( const TQString &query )
{
  clear();
  mClient->startQuery( query );
}

void LdapView::entryAdded( const TDEABC::LdapObject &obj )
{
  const TQString text = TQString( "%1 (%2)" ).arg( TQString(obj.attrs[ "surname" ].first()) )
                                           .arg( TQString(obj.attrs[ "mail" ].first()) );

  new LdapItem( this, text, obj.attrs[ "mail" ].first() );
}

void LdapView::error( const TQString &msg )
{
  KMessageBox::error( this, msg );
}

#include "ldapview.moc"
