/***************************************************************************
 *   Copyright (C) 2005 by Alexander Dymo                                  *
 *   adymo@kdevelop.org                                                    *
 *                                                                         *
 *   Copyright (c) 2005 by Matt Rogers                                     *
 *   mattr@kde.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "autotoolsast.h"

namespace AutoTools {

//AST

AST::~AST()
{
	for (TQValueList<AST*>::iterator it = m_children.begin(); it != m_children.end(); ++it)
	{
		AST *node = *it;
		delete node;
	}
}

void AST::addChildAST(AST *node)
{
	m_children.append(node);
}

void AST::writeBack(TQString &buffer)
{
	for (TQValueList<AST*>::const_iterator it = m_children.constBegin();
	     it != m_children.constEnd(); ++it)
	{
		if (*it)
			(*it)->writeBack(buffer);
	}
}

TQString AST::indentation()
{
	TQString result;
	for (int i = 0; i < depth(); i++)
		result += '\t';
	return result;
}

bool AST::hasChildren() const
{
	return !m_children.isEmpty();
}

TQValueList<AST*> AST::children() const
{
	return m_children;
}

//ProjectAST

void ProjectAST::writeBack(TQString &buffer)
{
	if ( isRule() )
		buffer += scopedID;
	else
		buffer += indentation();
	
	AST::writeBack(buffer);

}

void ProjectAST::addChildAST(AST *node)
{
	statements.append(node);
	AST::addChildAST(node);
}

void AssignmentAST::writeBack(TQString &buffer)
{
	buffer += indentation() + scopedID + " " + op + values.join("");
}

void AutomakeTargetAST::writeBack( TQString& buffer )
{
	buffer += target + ":" + deps.join("");
}

void ConditionAST::writeBack( TQString& buffer )
{
	buffer += indentation() + type + " " + conditionName;
}

void NewLineAST::writeBack(TQString &buffer)
{
	buffer += "\n";
}

void CommentAST::writeBack(TQString &buffer)
{
	buffer += indentation() + comment;
}

}
