#ifndef _VALGRINDITEM_H_
#define _VALGRINDITEM_H_

#include <tqvaluelist.h>
#include <tqstring.h>

class ValgrindBacktraceItem
{
public:
  enum Type { Unknown, SourceCode, Library };
  ValgrindBacktraceItem( const TQString& rawOutput = TQString() );
  ~ValgrindBacktraceItem();

  TQString message() const { return _message; }
  TQString address() const { return _address; }
  TQString url() const { return _url; }
  TQString function() const { return _function; }
  int line() const { return _line; }
  int pid() const { return _pid; }
  Type type() const { return _type; }
  bool isHighlighted() const { return _highlight; }
  void setHighlighted( bool h ) { _highlight = h; }
  
private:
  TQString _rawOutput, _address, _url, _function, _message;
  int _line;
  int _pid;
  Type _type;
  bool _highlight;
};

class ValgrindItem
{
public:
  ValgrindItem( const TQString& message );
  ~ValgrindItem();

  typedef TQValueList<ValgrindBacktraceItem> BacktraceList;  
  BacktraceList& backtrace() { return _backtrace; }
  const BacktraceList& backtrace() const { return _backtrace; }
  TQString message() const { return _message; }
  int pid() const { return _pid; }
  
private:
  BacktraceList _backtrace;
  TQString _message;
  int _pid;
};

#endif
