/***************************************************************************
 *   Copyright (C) 2004 by Paulo Moura Guedes                              *
 *   moura@kdewebdev.org                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef URL_H
#define URL_H

#include "../engine/linkstatus.h"
#include "node.h"

#include <kurl.h>
#include <tqstring.h>

#include <vector>

using namespace std;


class LinkStatus;

namespace Url
{
Node::LinkType resolveLinkType(TQString const& url);
KURL normalizeUrl(TQString const& string_url, LinkStatus const& link_parent, TQString const& document_root);
KURL normalizeUrl(TQString const& string_url);
bool validUrl(KURL const& url);
bool existUrl(KURL const& url, vector<LinkStatus*> const& v);
bool equalHost(TQString const& host1, TQString const& host2, bool restrict = false);
bool hasProtocol(TQString const& url);
TQString convertToLocal(LinkStatus const* ls);
bool localDomain(KURL const& url1, KURL const& url2, bool restrict = true);
bool parentDir(KURL const& url1, KURL const& url2);
bool externalLink(KURL const& url1, KURL const& url2, bool restrict = true);
}

inline bool validUrl(KURL const& url)
{
  return (url.isValid() /*&& url.hasHost()*/);
}

#endif
