/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include "defs.h"

int size_type_to_int( TQSizePolicy::SizeType t )
{
    if ( t == TQSizePolicy::Fixed )
	return 0;
    if ( t == TQSizePolicy::Minimum )
	return 1;
    if ( t == TQSizePolicy::Maximum )
	return 2;
    if ( t == TQSizePolicy::Preferred )
	return 3;
    if ( t == TQSizePolicy::MinimumExpanding )
	return 4;
    if ( t == TQSizePolicy::Expanding )
	return 5;
    if ( t == TQSizePolicy::Ignored )
	return 6;
    return 0;
}

TQString size_type_to_string( TQSizePolicy::SizeType t )
{
    if ( t == TQSizePolicy::Fixed )
	return "Fixed";
    if ( t == TQSizePolicy::Minimum )
	return "Minimum";
    if ( t == TQSizePolicy::Maximum )
	return "Maximum";
    if ( t == TQSizePolicy::Preferred )
	return "Preferred";
    if ( t == TQSizePolicy::MinimumExpanding )
	return "MinimumExpanding";
    if ( t == TQSizePolicy::Expanding )
	return "Expanding";
    if ( t == TQSizePolicy::Ignored )
	return "Ignored";
    return 0;
}

TQSizePolicy::SizeType int_to_size_type( int i )
{	
    if ( i == 0 )
	return TQSizePolicy::Fixed;
    if ( i == 1 )
	return TQSizePolicy::Minimum;
    if ( i == 2 )
	return TQSizePolicy::Maximum;
    if ( i == 3 )
	return TQSizePolicy::Preferred;
    if ( i == 4 )
	return TQSizePolicy::MinimumExpanding;
    if ( i == 5 )
	return TQSizePolicy::Expanding;
    if ( i == 6 )
	return TQSizePolicy::Ignored;
    return TQSizePolicy::Preferred;
}
