/***************************************************************************
    copyright            : (C) 2006 by Robby Stephenson
    email                : robby@periapsis.org

    Copyright (c) 2014 Timothy Pearson <kb9vqf@pearsoncomputing.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_NEWSTUFF_DIALOG_H
#define TELLICO_NEWSTUFF_DIALOG_H

#include "manager.h"

#include <kdialogbase.h>
#include <tdenewstuff/provider.h>

class KPushButton;
class KStatusBar;
namespace TDEIO {
  class Job;
}

class TQProgressBar;
class TQSplitter;
class TQLabel;
class TQTextEdit;

namespace Tellico {
  namespace GUI {
    class ListView;
    class CursorSaver;
  }

using namespace KNS;

namespace NewStuff {

class Dialog : public KDialogBase {
TQ_OBJECT
  

public:
  Dialog(DataType type, TQWidget* parent);
  virtual ~Dialog();

  TQPtrList<DataSourceInfo> dataSourceInfo() const { return m_manager->dataSourceInfo(); }

private slots:
  void slotProviders(Provider::List* list);
  void slotData(TDEIO::Job* job, const TQByteArray& data);
  void slotResult(TDEIO::Job* job);
  void slotJobData( TDEIO::Job *, const TQByteArray & );
  void slotJobResult( TDEIO::Job * );
  void slotPreviewResult(TDEIO::Job* job);

  void slotShowPercent(TDEIO::Job* job, unsigned long percent);

  void slotSelected(TQListViewItem* item);
  void slotInstall();
  void slotInstallPhase2();
  void slotDoneInstall(KNS::Entry* entry);

  void slotProviderError();
  void slotMoveProgress();

private:
  class Item;

  void setStatus(const TQString& status);
  void addEntry(KNS::Entry* entry);

  Manager* const m_manager;
  DataType m_type;
  TQString m_lang;
  TQString m_typeName;

  TQSplitter* m_split;
  GUI::ListView* m_listView;
  TQLabel* m_iconLabel;
  TQLabel* m_nameLabel;
  TQLabel* m_infoLabel;
  TQTextEdit* m_descLabel;
  KPushButton* m_install;
  KStatusBar* m_statusBar;
  TQProgressBar* m_progress;
  TQTimer* m_timer;
  GUI::CursorSaver* m_cursorSaver;
  KTempFile* m_tempPreviewImage;

  TQMap<TDEIO::Job*, KNS::Provider*> m_jobs;
  TQMap<TDEIO::Job*, TQByteArray> m_data;

  TQMap<TQListViewItem*, KNS::Entry*> m_entryMap;
  TQListViewItem* m_lastPreviewItem;

  KNS::Entry* mJobEntry;
  TQString mJobData;
};

  }
}
#endif
