/***************************************************************************
** $Id: torioslave.cpp,v 1.7 2008/07/31 19:56:29 hoganrobert Exp $
 *   Copyright (C) 2006 - 2008 Robert Hogan                                *
 *   robert@roberthogan.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.              *
 ***************************************************************************/

#include <tqcstring.h>
#include <tqsocket.h>
#include <tqdatetime.h>
#include <tqbitarray.h>

#include <tdeapplication.h>
#include <kdebug.h>
#include <tdemessagebox.h>
#include <tdeinstance.h>
#include <tdeglobal.h>
#include <kstandarddirs.h>
#include <tdelocale.h>
#include <kurl.h>
#include <ksock.h>
#include <dcopref.h>
#include <dcopclient.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <krun.h>
#include <kprocio.h>

#include <stdlib.h>
#include <math.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>

#include "torioslave.h"

using namespace TDEIO;


tdeio_torProtocol::tdeio_torProtocol(const TQCString &pool_socket, const TQCString &app_socket)
    : SlaveBase("tdeio_tor", pool_socket, app_socket)
{
}


tdeio_torProtocol::~tdeio_torProtocol()
{
}


void tdeio_torProtocol::get(const KURL& url )
{

    TQString wait;
    TQByteArray output;

    TQTextStream os( output, IO_WriteOnly );
    os.setEncoding( TQTextStream::Latin1 ); // In fast ASCII

    TQString cleanedurl = url.prettyURL().replace("tor://","");
    cleanedurl = cleanedurl.replace("tor:/","");
    cleanedurl = cleanedurl.replace("tor:","");
    cleanedurl = cleanedurl.replace(" ","");
    bool cantdo = false;

    if (cleanedurl.contains(".txt"))
        cantdo = true;

    if (cleanedurl.contains("://") && (cleanedurl.left(4) != "http"))
        cantdo = true;

    if (cantdo){

        os << TQString("<html><head><title>Tor</title></head><body>%1 is not a valid URL for this feature. Websites only I'm afraid. And no file extensions either!</body></html>").arg(cleanedurl);
    
        data( output );
        finished();
        return;
    }

    if ((cleanedurl.left(7) != "http://") && (cleanedurl.left(8) != "https://"))
        cleanedurl.prepend("http://");

    bool m_torkrunning = false;
    bool anonymized = false;

    DCOPClient* p_dcopServer= new DCOPClient();
    p_dcopServer->attach ();

    if (p_dcopServer->isApplicationRegistered ("tork")){
            m_torkrunning = true;
            DCOPRef tork( "tork", "DCOPTork" );
            anonymized = tork.call( "getTDESetting" );
    }

    

    if (m_torkrunning){
        DCOPRef("tork*", "DCOPTork").send("startEverything");
        if (!anonymized)
            DCOPRef("tork*", "DCOPTork").send("toggleTDESetting");
        wait = "3";
    }else{
        KProcIO *whichproc = new KProcIO();
        whichproc->setUseShell(true);
        TQString whichCommand="tork --toggleTDE";
    
        *whichproc<<whichCommand;
    
        whichproc->start(KProcIO::NotifyOnExit,true);

        //KRun::runCommand( "tork --toggleTDE");
        wait = "10";
    }


    os << TQString("<html><head><title>Tor</title><META HTTP-EQUIV='Refresh' CONTENT='%1; URL=%2'></head><body>Will load %3 anonymously in a moment.</body></html>").arg(wait).arg(cleanedurl).arg(cleanedurl);

    data( output );
    finished();

}


void tdeio_torProtocol::mimetype(const KURL & /*url*/)
{
    mimeType("text/html");
    finished();
}


extern "C"
{
    int kdemain(int argc, char **argv)
    {
        TDEInstance instance( "tdeio_tor" );
        
        kdDebug(7101) << "*** Starting tdeio_tor " << endl;
        
        if (argc != 4) {
            kdDebug(7101) << "Usage: tdeio_tor  protocol domain-socket1 domain-socket2" << endl;
            exit(-1);
        }
        
        tdeio_torProtocol slave(argv[2], argv[3]);
        slave.dispatchLoop();
        
        kdDebug(7101) << "*** tdeio_tor Done" << endl;
        return 0;
    }
} 
