/***************************************************************************
*   Copyright (C) 2003 by Sandro Giessl                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include <tdeconfig.h>
#include <tdelocale.h>
#include <tdeglobal.h>
#include <tqcheckbox.h>
#include <tqslider.h>
#include <tqspinbox.h>
#include <tqcombobox.h>
#include <tqwhatsthis.h>

#include "malloryconfig.h"
#include "configdialog.h"

MalloryConfig::MalloryConfig(TDEConfig* config, TQWidget* parent)
    : TQObject(parent), m_config(0), m_dialog(0)
{
    // Create the configuration object.
    m_config = new TDEConfig("twinmalloryrc");
    TDEGlobal::locale()->insertCatalogue("twin_mallory_config");

    // Create and show the configuration dialog.
    m_dialog = new ConfigDialog(parent);
    m_dialog->show();

    // Load the configuration.
    load(config);

    // Setup the connections.
    connect(m_dialog->m_borderSize, TQ_SIGNAL(valueChanged(int)), this, TQ_SIGNAL(changed()));
    connect(m_dialog->m_titleSize, TQ_SIGNAL(valueChanged(int)), this, TQ_SIGNAL(changed()));
    connect(m_dialog->m_buttonSize, TQ_SIGNAL(valueChanged(int)), this, TQ_SIGNAL(changed()));
    connect(m_dialog->m_lessRounded, TQ_SIGNAL(toggled(bool)), this, TQ_SIGNAL(changed()));
    connect(m_dialog->m_buttonStyle, TQ_SIGNAL(activated(int)), this, TQ_SIGNAL(changed()));
    connect(m_dialog->m_resizeHandle, TQ_SIGNAL(toggled(bool)), this, TQ_SIGNAL(changed()));
    connect(m_dialog->m_superSize, TQ_SIGNAL(toggled(bool)), this, TQ_SIGNAL(changed()));
    connect(m_dialog->m_titleShadow, TQ_SIGNAL(toggled(bool)), this, TQ_SIGNAL(changed()));
    connect(m_dialog->m_titleShadowSize, TQ_SIGNAL(valueChanged(int)), this, TQ_SIGNAL(changed()));

}

MalloryConfig::~MalloryConfig()
{
    if (m_dialog) delete m_dialog;
    if (m_config) delete m_config;
}

void MalloryConfig::load(TDEConfig*)
{
    m_config->setGroup("General");

    int borderSize = m_config->readNumEntry("BorderSize", 5);
    m_dialog->m_borderSize->setValue(borderSize);
    int buttonSize = m_config->readNumEntry("ButtonSize", 18);
    m_dialog->m_buttonSize->setValue(buttonSize);
    int titleSize = m_config->readNumEntry("TitleSize", 22);
    m_dialog->m_titleSize->setValue(titleSize);
    bool lessRounded = m_config->readBoolEntry("LessRounded", false);
    m_dialog->m_lessRounded->setChecked(lessRounded);
    int buttonStyle = m_config->readNumEntry("ButtonStyle", 0);
    m_dialog->m_buttonStyle->setCurrentItem(buttonStyle);
    bool resizeHandle = m_config->readBoolEntry("ResizeHandle", true);
    m_dialog->m_resizeHandle->setChecked(resizeHandle);
    bool superSize = m_config->readBoolEntry("SuperSize", true);
    m_dialog->m_superSize->setChecked(superSize);
    bool titleShadow = m_config->readBoolEntry("TitleShadow", true);
    m_dialog->m_titleShadow->setChecked(titleShadow);
    int titleShadowSize = m_config->readNumEntry("TitleShadowSize", 2);
    m_dialog->m_titleShadowSize->setValue(titleShadowSize);
}

void MalloryConfig::save(TDEConfig*)
{
    m_config->setGroup("General");

    m_config->writeEntry("ButtonSize", m_dialog->m_buttonSize->value());
    m_config->writeEntry("TitleSize", m_dialog->m_titleSize->value());
    m_config->writeEntry("BorderSize", m_dialog->m_borderSize->value());
    m_config->writeEntry("LessRounded", m_dialog->m_lessRounded->isChecked());
    m_config->writeEntry("ButtonStyle", m_dialog->m_buttonStyle->currentItem());
    m_config->writeEntry("ResizeHandle", m_dialog->m_resizeHandle->isChecked());
    m_config->writeEntry("SuperSize", m_dialog->m_superSize->isChecked());
    m_config->writeEntry("TitleShadow", m_dialog->m_titleShadow->isChecked());
    m_config->writeEntry("TitleShadowSize", m_dialog->m_titleShadowSize->value());
    m_config->sync();
}

void MalloryConfig::defaults()
{
    m_dialog->m_titleSize->setValue(22);
    m_dialog->m_buttonSize->setValue(18);
    m_dialog->m_borderSize->setValue(5);
    m_dialog->m_lessRounded->setChecked(false);
    m_dialog->m_buttonStyle->setCurrentItem(0);
    m_dialog->m_resizeHandle->setChecked(true);
    m_dialog->m_superSize->setChecked(true);
    m_dialog->m_titleShadow->setChecked(true);
    m_dialog->m_titleShadowSize->setValue(2);
}

//////////////////////////////////////////////////////////////////////////////
// Plugin Stuff                                                             //
//////////////////////////////////////////////////////////////////////////////

extern "C"
{
    TDE_EXPORT TQObject* allocate_config(TDEConfig* config, TQWidget* parent) {
        return (new MalloryConfig(config, parent));
    }
}

#include "malloryconfig.moc"
