//
// C++ Interface: starmanager
//
// Description: Small little manager to return the color stars we want
//
//
// Author: Jeff Mitchell <kde-dev@emailgoeshere.com>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//


#ifndef AMAROK_STAR_MANAGER_H
#define AMAROK_STAR_MANAGER_H

#include <tqimage.h>
#include <tqpixmap.h>

class StarManager : public TQObject
{

    TQ_OBJECT
  

    public:
        StarManager();
        ~StarManager();
        static StarManager *instance();

        TQPixmap* getStar( int num, bool full = false );
        TQPixmap* getGreyStar() { return &m_greyedStarPix; }
        TQPixmap* getHalfStar( int num = -1, bool full = false  );
        TQImage& getStarImage( int num, bool full = false  );
        TQImage& getGreyStarImage() { return m_greyedStar; }
        TQImage& getHalfStarImage( int num = -1, bool full = false  );

        bool setColor( int starNum, const TQColor &color );
        bool setHalfColor( const TQColor &color );

        void reinitStars( int height = -1, int margin = -1 );

    signals:
        void ratingsColorsChanged( const TQString &url );

    private:

        int m_height;
        int m_margin;

        //cached stars...why both?  For faster conversion when drawing context browser
        TQPixmap m_starPix;
        TQImage m_star;
        TQPixmap m_fullStarPix;
        TQImage m_fullStar;
        TQPixmap m_greyedStarPix;
        TQImage m_greyedStar;
        TQPixmap m_halfStarPix;
        TQPixmap m_fullHalfStarPix;
        TQImage m_halfStar;
        TQImage m_fullHalfStar;

        TQImage m_images[5];
        TQImage m_halfimages[5];
        TQPixmap m_pixmaps[5];
        TQPixmap m_halfpixmaps[5];

        TQColor m_colors[5];
        TQColor m_halfStarColor;
};

#endif

