/***************************************************************************
                          loader.h  -  loader application for Amarok
                             -------------------
    begin                : 2004/02/19
    copyright            : (C) 2004 Mark Kretschmann <markey@web.de>
                           (C) 2005 Max Howell
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LOADER_H
#define LOADER_H

#include <tqapplication.h>

class TQProcess;
class TQStringList;

class Loader : public TQApplication
{
public:
    Loader( TQStringList );
   ~Loader();

private:
    virtual void timerEvent( TQTimerEvent* );

    TQProcess *m_proc;
    int       m_counter;
    TQWidget  *m_splash;

    static const int INTERVAL = 10; //ms
};

static bool isSplashEnabled();
static bool amarokIsRunning();

#define foreach( x ) \
    for( TQStringList::ConstIterator it = x.begin(), end = x.end(); it != end; ++it )

#endif
