/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2004-02-12
 * Description : main program from digiKam theme designer
 *
 * Copyright (C) 2004-2005 by Renchi Raju <renchi at pooh.tam.uiuc.edu>
 * Copyright (C) 2006-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// TQt includes.

#include <tqstring.h>

// KDE includes.

#include <tdeapplication.h>
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdeglobal.h>
#include <tdelocale.h>

// Local includes.

#include "daboutdata.h"
#include "mainwindow.h"

static const char *description = Digikam::themeDesignerDescription();

static TDECmdLineOptions options[] =
{
    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
    TDECmdLineLastOption
};

int main(int argc, char** argv)
{
    TDEAboutData aboutData("digikamthemedesigner",
                     I18N_NOOP("digiKam Theme Designer"),
                     digikam_version,
                     description,
                     TDEAboutData::License_GPL,
                     Digikam::copyright(),
                     0,
                     Digikam::webProjectUrl());

    Digikam::authorsRegistration(aboutData);

    TDECmdLineArgs::init(argc, argv, &aboutData);
    TDECmdLineArgs::addCmdLineOptions(options);

    TDEGlobal::locale()->setMainCatalogue( "digikam" );

    TDEApplication app;
    Digikam::MainWindow *im = new Digikam::MainWindow();
    app.setMainWidget(im);
    im->resize(800, 600);
    im->show();

    return app.exec();
}
