/*
Gwenview - A simple image viewer for TDE
Copyright 2000-2004 Aur�lien G�teau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

// KDE includes
#include <tdefileitem.h>

// Our includes
#include "archive.h"
namespace Gwenview {


namespace Archive {

typedef TQMap<TQString,TQString> MimeTypeProtocols;

static const char* KDE_PROTOCOL = "X-TDE-LocalProtocol";

static const MimeTypeProtocols& mimeTypeProtocols() {
	static MimeTypeProtocols map;
	if (map.isEmpty()) {
		KMimeType::List list = KMimeType::allMimeTypes();
		KMimeType::List::Iterator it=list.begin(), end=list.end();
		for (; it!=end; ++it) {
			if ( (*it)->propertyNames().findIndex(KDE_PROTOCOL)!= -1 ) {
				TQString protocol = (*it)->property(KDE_PROTOCOL).toString();
				map[(*it)->name()] = protocol;
			}
		}
	}
	return map;
}

	
bool fileItemIsArchive(const KFileItem* item) {
	return mimeTypeProtocols().contains(item->mimetype());
}

bool fileItemIsDirOrArchive(const KFileItem* item) {
	return item->isDir() || Archive::fileItemIsArchive(item);
}

bool protocolIsArchive(const TQString& protocol) {
	const MimeTypeProtocols& map=mimeTypeProtocols();
	MimeTypeProtocols::ConstIterator it;
	for (it=map.begin();it!=map.end();++it) {
		if (it.data()==protocol) return true;
	}
	return false;
}

TQStringList mimeTypes() {
	const MimeTypeProtocols& map=mimeTypeProtocols();
	MimeTypeProtocols::ConstIterator it;
	TQStringList strlist;
	for (it=map.begin();it!=map.end();++it) {
		strlist+=it.key();
	}
	return strlist;
	//return mimeTypeProtocols().keys(); // keys() does not exist in TQt 3.0
}


TQString protocolForMimeType(const TQString& mimeType) {
	return mimeTypeProtocols()[mimeType];
}

}

} // namespace
