/***************************************************************************
                          definition.h  -  description
                             -------------------
    begin                : Mit Nov 20 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
                                                                          
    This program is free software; you can redistribute it and/or modify  
    it under the terms of the GNU General Public License as published by  
    the Free Software Foundation; either version 2 of the License, or     
    (at your option) any later version.                                   
                                                                          
 ***************************************************************************/

#ifndef DEFINITION_H
#define DEFINITION_H

#include "measurements.h"
#include "labelutils.h"
#include <tqmap.h>
#include <tqstring.h>

#ifndef I2S
    #define I2S(x) TQString::number(x)
#endif // I2S

class TQWidget;
class TQFile;
class TQPaintDevice;
class TQString;
class TQStringList;
class TQSqlQuery;
class Measurements;
class TQProgressDialog;
/** @short A label definition;
  *
  * Represents a label definition. The definition is either read from
  * a SQL database or from a text file on the harddisk.
  * This class supports also writing new label definitions.
  * After you selected a definition, you can retrieve its measurements.
  *
  * @author Dominik Seichter
  */
class Definition : private LabelUtils {
    public:
        Definition( TQWidget* parent = 0 );
        Definition( int label_def_id, TQWidget* parent = 0 );
        Definition( const TQString & label_def_id, TQWidget* parent = 0 );
        Definition( const TQString & producer, const TQString & type, TQWidget* parent = 0 );
        ~Definition();

        void setId( const TQString & label_def_id );
        void setId( int label_def_id );

        const Measurements & getMeasurements() const;

        static int write( const Measurements & c, TQString type, TQString producer );
        static int getClosest( const TQString & producer, const TQString & type );
        
        static const TQStringList getProducers();
        static const TQStringList getTypes( TQString producer );        
        /** reread the list of producers, because it has changed
          * mapType is also cleared and reread when necessary.
          */
        static void updateProducer();

        int getId() const { return id; }
        const TQString getProducer() const { return producer; }
        const TQString getType() const { return type; }

    private:
        void init( const TQString & label_def_id );
        void getFileMeasurements( const TQString & label_def_id );
	static void initProgress();
	static void increaseProgress();
	static void destroyProgress();

        static int writeSQL( const Measurements & c, TQString type, TQString producer );
        static int writeFile( const Measurements & c, TQString type, TQString producer );
        
        static bool showFileError();
        static bool openFile();
        static TQStringList* listProducers;
        static TQMap<TQString,TQStringList> mapTypes;
        static TQFile* file;
        static TQByteArray* array;
	static TQProgressDialog* m_progress;

	TQWidget* m_parent;
        int id;
        TQString producer;
        TQString type;
        Measurements m_measure;
        bool locked;
        static bool nodefmsg;
};

#endif
