/* This file is part of the Keep project
   Copyright (C) 2005 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */

#include <tdelocale.h>
#include <tdecmdlineargs.h>
#include <twin.h>
#include <tdeaboutdata.h>
#include <tdeuniqueapplication.h>
#include <kdebug.h>

#include "keepmainwindow.h"

static const char *description = 
        I18N_NOOP( "TDE Backup System" );

int main(int argc, char **argv)
{
	TDEAboutData aboutData( "keep", I18N_NOOP( "Keep" ),"0.4.0", description, TDEAboutData::License_GPL_V2,
        "(c) 2005 Jean-Rémy Falleri" );
	aboutData.addAuthor( "Jean-Rémy Falleri", I18N_NOOP( "Maintainer" ),
        "jr.falleri@laposte.net" );
	aboutData.addCredit("Anthony Mercatante",I18N_NOOP("Ubuntu packages"));
	aboutData.addCredit("John Eckerson", I18N_NOOP("Application wording"));
	aboutData.addCredit("auxsvr", I18N_NOOP("Useful patches"));
	
	TDECmdLineArgs::init( argc, argv, &aboutData );
	TDEUniqueApplication::addCmdLineOptions();

	if ( !TDEUniqueApplication::start() )
	{
		kdDebug() << "Already running, exiting." << endl;
		return 0;
	}

	TDEUniqueApplication app;
	app.disableSessionManagement();

	KeepMainWindow *keep = new KeepMainWindow( 0, "keep" );
	keep->show();
	app.setMainWidget( keep );

	return app.exec();
}

