/***************************************************************************
 *   Copyright (C) 2006 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "omnibookthermalsrc.h"
#include <tqtextstream.h> 
#include <tqfile.h>
#include <tdelocale.h>

OmnibookThermalSrc::OmnibookThermalSrc(TQWidget* inParent, const TQFile& inSourceFile):
		LabelSource(inParent),
		mSourceFile(inSourceFile.name()),
		mTrigger(this){
	mID = "CPU";
	mName = mID;
	mDescription = i18n("This source is provided by the Omnibook Configuration Tools & Patches.");
}

OmnibookThermalSrc::~OmnibookThermalSrc(){
}

std::list<Source*>OmnibookThermalSrc::createInstances(TQWidget* inParent){
	std::list<Source*> list;
	TQFile omiFile( "/proc/omnibook/temperature" );
	if(omiFile.open(IO_ReadOnly)){
		list.push_back(new OmnibookThermalSrc(inParent, omiFile));
	}
	return list;
}

TQString OmnibookThermalSrc::fetchValue(){
	TQString s = "n/a";
	if(mSourceFile.open(IO_ReadOnly)){
		TQTextStream textStream( &mSourceFile );
		s = textStream.readLine();
		mSourceFile.close();
		s = s.section(':',-1,-1, TQString::SectionSkipEmpty).stripWhiteSpace();
        s = formatTemperature(s.left(s.length()-1));
	}
	return s;
}
#include "omnibookthermalsrc.moc"
