/*
   This file is part of the KDE project
   Copyright (C) 2004 Martijn Klingens <klingens@kde.org>
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#ifndef KCMAUTOSTART_H
#define KCMAUTOSTART_H

#include <tqlistview.h>
#include <tdecmodule.h>

class TDEListView;
class TQStringList;
class TQPushButton;

class AutoStartConfig : public TDECModule
{
TQ_OBJECT
  
public:
	AutoStartConfig(TQWidget* parent, const char* name= 0L, const TQStringList& foo = TQStringList());
	~AutoStartConfig() {};

	void       load();
	void       save();
	void       defaults();

	TQString quickHelp() const;

protected slots:
	void slotReload();
	void slotItemChecked(TQCheckListItem *item);

        bool autoloadEnabled(TDEConfig *config, const TQString &filename);
        void setAutoloadEnabled(TDEConfig *config, const TQString &filename, bool b);

private:
	TDEListView *_lvStartup;
};

class CheckListItem : public TQObject, public TQCheckListItem
{
	TQ_OBJECT
  
public:
	CheckListItem(TQListView* parent, const TQString &text);
	~CheckListItem() { }
signals:
	void changed(TQCheckListItem*);
protected:
	virtual void stateChange(bool);
};

#endif // KCMAUTOSTART_H

