/* ============================================================
 * File  : dmessagebox.cpp
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2003-02-22
 * Description :
 *
 * Copyright 2003 by Renchi Raju <renchi@pooh.tam.uiuc.edu>

 * Update : 09/23/2003 - Gilles Caulier <caulier.gilles@free.fr>
 *          Center the dialog box on the desktop.
 *          Improve i18n messages.

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// TQt
#include <tqapplication.h>
#include <tqhbox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqpixmap.h>
#include <tqpushbutton.h>
#include <tqtextedit.h>
// KDE
#include <tdelocale.h>
#include <tdeapplication.h>
#include <kiconloader.h>
// Local
#include "dmessagebox.h"

namespace KIPIKameraKlientPlugin
{

DMessageBox* DMessageBox::s_instance = 0;

DMessageBox::DMessageBox() : TQWidget(0, 0, WShowModal | WStyle_DialogBorder| WDestructiveClose) {
    setCaption(i18n("Error"));
    s_instance = this;
    count_ = 0;
    TQGridLayout *grid = new TQGridLayout(this, 1, 1, 6, 11);
    // ----------------------------------------------------
    TQHBox *hbox = new TQHBox(this);
    hbox->setSpacing(5);
    TQPixmap pix = tdeApp->iconLoader()->loadIcon("error",
                                                                       TDEIcon::NoGroup,
                                                                       TDEIcon::SizeMedium,
                                                                       TDEIcon::DefaultState,
								       0, true);
    TQLabel *pixLabel = new TQLabel(hbox);
    pixLabel->setPixmap(pix);
    pixLabel->setSizePolicy(TQSizePolicy(TQSizePolicy::Minimum, TQSizePolicy::Minimum));
    msgBox_ = new TQLabel(hbox);
    msgBox_->setSizePolicy(TQSizePolicy(TQSizePolicy::Expanding, TQSizePolicy::Minimum));
    grid->addMultiCellWidget(hbox, 0, 0, 0, 2);
    // ---------------------------------------------------
    extraMsgBox_ = new TQTextEdit(this);
    extraMsgBox_->setReadOnly(true);
    grid->addMultiCellWidget(extraMsgBox_, 1, 1, 0, 2);
    extraMsgBox_->hide();
    // ---------------------------------------------------
    TQPushButton *okButton = new TQPushButton(i18n("&OK"), this);
    grid->addWidget(okButton, 2, 1);
    // ---------------------------------------------------
    grid->addItem(new TQSpacerItem(5, 10, TQSizePolicy::Expanding, TQSizePolicy::Minimum), 2, 0);
    grid->addItem(new TQSpacerItem(5, 10, TQSizePolicy::Expanding, TQSizePolicy::Minimum), 2, 2);
    // ---------------------------------------------------
    connect(okButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotOkClicked()));
    int W=500;
    int H=400;
    move(TQApplication::desktop()->width ()/2-(W/2), TQApplication::desktop()->height()/2-(H/2));
}

DMessageBox::~DMessageBox() {
    s_instance = 0;
}

void DMessageBox::appendMsg(const TQString& msg) {
    if (count_ == 0) {
        mainMsg_ = msg;
        msgBox_->setText(msg);
    } else {
        TQString text(i18n("More errors occurred and are shown below:"));
        msgBox_->setText(text);
        extraMsgBox_->append(msg);
        if (extraMsgBox_->isHidden()) {
            extraMsgBox_->show();
	}
    }
    count_++;
}

void DMessageBox::slotOkClicked() {
    close();
}

void DMessageBox::showMsg(const TQString& msg) {
    DMessageBox* msgBox = DMessageBox::s_instance;
    if (!msgBox) {
        msgBox = new DMessageBox;
    }
    msgBox->appendMsg(msg);
    if (msgBox->isHidden()) {
        msgBox->show();
    }
}

}  // NameSpace KIPIKameraKlientPlugin

#include "dmessagebox.moc"
