/* ============================================================
 * File  : sinklist.cpp
 * Author: Colin Guthrie <kde@colin.guthr.ie>
 * Date  : 2006-09-04
 * Copyright 2006 by Colin Guthrie <kde@colin.guthr.ie>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */


// Include files for KDE

#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdeapplication.h>
#include <kpushbutton.h>


// Local includes.

#include "sinks.h"
#include "sinklist.h"
//#include "sinkconfig.h"

namespace KIPISyncPlugin
{

SinkList::SinkList(TQWidget *pParent, Sinks* pSinks, bool blnShowOpen)
    : SinkListBase(pParent),
      mpSinks(pSinks),
      mpCurrentSink(0)
{
  buttonOpen->setEnabled(blnShowOpen);
  buttonRemove->setEnabled(false);
  buttonConfigure->setEnabled(false);
  
  listSinks->addColumn(i18n("Name"));
  listSinks->addColumn(i18n("Type"));
  mpSinks->asTQListView(listSinks);
}

SinkList::~SinkList()
{

}

Sink* SinkList::GetSink()
{
  return mpCurrentSink;
}

void SinkList::selectionChanged()
{
  TQListViewItem* p_lvi = listSinks->selectedItem();
  bool bln_selected = (p_lvi ? true : false);
  buttonRemove->setEnabled(bln_selected);
  buttonConfigure->setEnabled(bln_selected);
  buttonOpen->setEnabled(bln_selected);

  if (bln_selected)
  {
    SinkTQListViewItem* p_glvi = dynamic_cast<SinkTQListViewItem*>(p_lvi);
    mpCurrentSink = p_glvi->GetSink();
  }
  else
  {
    mpCurrentSink = 0;
  }
}

void SinkList::doubleClicked(TQListViewItem* pCurrent, const TQPoint&, int)
{
  if (!pCurrent)
    return;

  if (buttonOpen->isEnabled())
  {
    accept();
  }
  else
  {
    buttonConfigure_clicked();
  }
}

//==================   Add   =====
void SinkList::buttonAdd_clicked(void)
{
/*
  Sink* p_sink = new Sink();
  SinkEdit dlg(this, p_sink, i18n("New Sink"));
  if (TQDialog::Accepted == dlg.exec())
  {
    mpSinks->Add(p_sink);
    mpSinks->Save();
    p_sink->asTQListViewItem(mpSinkList);
  }
  else
  {
    delete p_sink;
  }
*/
}


//==================   Edit  ======
void SinkList::buttonConfigure_clicked(void)
{
  TQListViewItem* p_lvi = listSinks->selectedItem();
  if (!p_lvi)
  {
    KMessageBox::error(tdeApp->activeWindow(), i18n("No sink selected!"));
  }
  else
  {
    /*
    SinkTQListViewItem* p_glvi = dynamic_cast<SinkTQListViewItem*>(p_lvi);
    SinkEdit dlg(this, p_glvi->GetSink(), i18n("Edit Sink"));
    if (TQDialog::Accepted == dlg.exec())
    {
      p_glvi->Refresh();
      mpSinks->Save();
    }
    */
  }
}


//==================  Remove ======
void SinkList::buttonRemove_clicked(void)
{
  TQListViewItem* p_lvi = listSinks->selectedItem();
  if (!p_lvi)
  {
    KMessageBox::error(tdeApp->activeWindow(), i18n("No sink selected!"));
  }
  else
  {
    if (KMessageBox::Yes == 
          KMessageBox::warningYesNo(tdeApp->activeWindow(),
            i18n("Are you sure you want to remove this sink? "
                 "All synchronisaton settings will be lost. "
                 "You cannot undo this action."), 
            i18n("Remove Sink?"), 
            KStdGuiItem::yes(), KStdGuiItem::no(),
            TQString(), KMessageBox::Dangerous))
    {
      SinkTQListViewItem* p_glvi = dynamic_cast<SinkTQListViewItem*>(p_lvi);
      Sink* p_sink = p_glvi->GetSink();
      delete p_glvi;
      mpSinks->Remove(p_sink);
      mpSinks->Save();
    }
  }
}

}

#include "sinklist.moc"

