/***************************************************************************
 *   Copyright (C) 2004 by Sashmit Bhaduri                                 *
 *   smt@vfemail.net                                                       *
 *                                                                         *
 *   Licensed under GPL.                                                   *
 ***************************************************************************/


#include "viewer.h"
#include "klamav_run.h"

using namespace KlamAV;


BrowserRun::BrowserRun(Viewer *viewer, TQWidget *parent, KParts::ReadOnlyPart *part, const KURL & url, const KParts::URLArgs &args)
    : KParts::BrowserRun(url, args, part, parent, false, true)
{
    m_viewer=viewer;
    connect(m_viewer, TQ_SIGNAL(destroyed()), this, TQ_SLOT(killMyself()));
    setEnableExternalBrowser(false);

}

BrowserRun::~BrowserRun()
{
    //kdDebug() << "BrowserRun::~BrowserRun()" << endl;
}

void BrowserRun::foundMimeType( const TQString & type )
{
    if (type=="text/html" ||type=="text/xml" || type=="application/xhtml+xml"  )
        m_viewer->openPage(url());
    else
        KParts::BrowserRun::foundMimeType( type );
}

void BrowserRun::killMyself()
{
    kdDebug() << "BrowserRun::killMyself()" << endl;
    delete this;
}

#include "klamav_run.moc"
