/*
   This file is part of libtdepim.
   Copyright (c) 2004 Daniel Molkentin <molkentin@kde.org>
   based on code by Cornelius Schumacher <schumacher@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/


#include "clicklineedit.h"
#include "klamscan.h"
#include "klamav.h"

#include "tqpainter.h"

ClickComboBox::ClickComboBox(   bool   rw,TQWidget *parent, const char* name ) :
        KComboBox( rw,parent, name )
{
/*    mDrawClickMsg = true;
    setClickMessage( msg );*/
}


/////////////////////////////////////////////////////////////////////////////////////
// PUBLIC
/////////////////////////////////////////////////////////////////////////////////////

// void ClickComboBox::setClickMessage( const TQString &msg )
// {
//     mClickMessage = msg;
//     repaint();
// }


void ClickComboBox::mousePressEvent( TQMouseEvent * e )
{

    TQComboBox::mousePressEvent( e );
    repaint();

}


/////////////////////////////////////////////////////////////////////////////////////
// PROTECTED
/////////////////////////////////////////////////////////////////////////////////////

void ClickComboBox::paintEvent( TQPaintEvent * ev)
{

	KComboBox::paintEvent(ev);

   	if (tdemain->klamscan->isMultiScan()){
		//kdDebug() << "drawing text" << endl;
		TQPainter p (this->lineEdit());
		p.setPen( palette().color( TQPalette::Disabled, TQColorGroup::Text ) );
		TQRect cr = this->lineEdit()->contentsRect();
	//        Add two pixel margin on the left side
		//cr.setRight( cr.right() + 800 );
		cr.setWidth(800);
		//kdDebug() << cr << endl;
		p.drawText( cr, AlignAuto , i18n( "Multiple Directories Selected" ) );
		//this->setPaletteForegroundColor(palette().color( TQPalette::Disabled, TQColorGroup::Text ));
	}
}


void ClickComboBox::focusInEvent( TQFocusEvent *ev )
{
/*    if ( mDrawClickMsg == true ) {
        mDrawClickMsg = false;
        repaint();
    }*/
    TQComboBox::focusInEvent( ev );
}


void ClickComboBox::focusOutEvent( TQFocusEvent *ev )
{
/*    if ( currentText().isEmpty() ) {
        mDrawClickMsg = true;
        repaint();
    }*/
    TQComboBox::focusOutEvent( ev );
}

