/***************************************************************************
                         directorylist.h
                            -------------------
   begin                : Tue Feb 4 2003
   copyright            : (C) 2003 Scott Wheeler <wheeler@kde.org>
                        : (C) 2004 Max Howell <max.howell@methylblue.com>
                        : (C) 2004 Mark Kretschmann <markey@web.de>
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _DIRECTORYLIST_H
#define _DIRECTORYLIST_H

#include <tqcheckbox.h>  //inlined functions
#include <tqlistview.h>  //baseclass
#include <tqvbox.h>      //baseclass
#include <tqstringlist.h>

#include <kdirlister.h> //stack allocated
#include <kurl.h>       //stack allocated


namespace Collection { class Item; }


class CollectionSetup : public TQVBox
{
TQ_OBJECT
    friend class Collection::Item;

public:
    CollectionSetup( TQWidget *parent, bool recursive, bool fullMode = true, TQStringList dirs = TQStringList() );

    TQStringList dirs() const { return m_dirs; }
    bool recursive() const { return m_recursive; }
//     bool monitor() const { return m_monitor->isChecked(); }
//     bool importPlaylists() const { return m_playlists->isChecked(); }
    TQStringList m_dirs;
    TQMap<TQString,int> m_refcount;

    static TQStringList pruneSelectedDirs( TQStringList listOfUrls = 0 );
    void writeConfig( const char* optGroup, const char* optName );
    void reset();

signals:
    void dirsSelected(TQStringList& dirs);
    void resetDirs();

public slots:

    void slotRecursiveToggled(bool on);

private:
    TQListView *m_view;
    bool m_recursive;
    TQCheckBox *m_monitor;
    TQCheckBox *m_playlists;
};


namespace Collection { //just to keep it out of the global namespace

class Item : public TQObject, public TQCheckListItem
{
TQ_OBJECT
public:
    Item( TQListView *parent, CollectionSetup *collection, const TQString &name, const TQString &path, const TQString &icon=TQString::null );
    Item( TQListViewItem *parent, CollectionSetup *collection, const KURL &url );

    TQCheckListItem *parent() const { return (TQCheckListItem*)TQListViewItem::parent(); }
    bool isDisabled() const { return collectionSetup->recursive() && parent() && parent()->isOn(); }
    TQString fullPath() const;

    void setOpen( bool b ); // reimpl.
    void stateChange( bool ); // reimpl.
    void activate(); // reimpl.
    void paintCell( TQPainter * p, const TQColorGroup & cg, int column, int width, int align ); // reimpl.

public slots:
    void newItems( const KFileItemList& );
    void completed() { if( childCount() == 0 ) { setExpandable( false ); repaint(); } }
    void reset();

private:
    CollectionSetup *collectionSetup;
    KDirLister m_lister;
    KURL       m_url;
    bool       m_listed;
};


class DeviceItem : public TQObject, public TQCheckListItem
{
   TQ_OBJECT
   public:
      DeviceItem( TQListView *parent, CollectionSetup *collection );
      DeviceItem( TQListViewItem *parent, CollectionSetup *collection, const TQString &name, const KURL &url );

      TQCheckListItem *parent() const { return (TQCheckListItem*)TQListViewItem::parent(); }
      bool isDisabled() const { return collectionSetup->recursive() && parent() && parent()->isOn(); }
      TQString fullPath() const;

      void setOpen( bool b ); // reimpl.
      void stateChange( bool ); // reimpl.
      void activate(); // reimpl.
      void paintCell( TQPainter * p, const TQColorGroup & cg, int column, int width, int align ); // reimpl.
      TQString getMountPoint(const TQString & device);
   public slots:
      void newItems( const KFileItemList& );
      void completed() { if( childCount() == 0 ) { setExpandable( false ); repaint(); } }
      void reset();
    private:
      void mountDevice(const TQString & device);
      CollectionSetup *collectionSetup;
      KDirLister m_lister;
      KURL       m_url;
      bool       m_listed;
};
} //namespace



#endif
