############################################
#                                          #
#  Improvements and feedbacks are welcome  #
#                                          #
#  This file is released under GPL >= 3    #
#                                          #
############################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_compiler_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for X11

find_package( X11 )


##### check for XExt, Xv

if( NOT X11_FOUND )
    tde_message_fatal( "X11 is required, but was not found on your system." )
elseif( NOT X11_Xext_FOUND AND ( BUILD_KXVPLAYER OR BUILD_KXINEPLAYER ) )
    tde_message_fatal( "libXext is required, but was not found on your system." )
elseif( NOT X11_Xv_FOUND AND BUILD_KXVPLAYER )
    tde_message_fatal( "libXv is required, but was not found on your system." )
endif()


##### check for cairo

if( WITH_CAIRO )
    pkg_search_module( CAIRO cairo )

    if( CAIRO_FOUND )
        set( HAVE_CAIRO 1 )
     else()
        tde_message_fatal( "Cairo support has been requested but cairo was not found on your system." )
    endif()
endif( WITH_CAIRO )


##### check for expat

if( WITH_EXPAT )
    find_package( EXPAT )

    if( EXPAT_FOUND )
        set( HAVE_EXPAT 1 )
     else()
        tde_message_fatal( "Expat support has been requested but expat was not found on your system." )
    endif()
endif( WITH_EXPAT )


##### check for XTest

if( WITH_XTEST )
    pkg_search_module( X11_XTEST xtst )

    if( X11_XTest_FOUND )
        set( HAVE_XTEST 1 )
     else()
        tde_message_fatal( "XTest support has been requested but xtest was not found on your system." )
    endif()
endif( WITH_XTEST )


##### check for npplayer

if ( BUILD_KNPPLAYER )
     pkg_search_module( DBUS      dbus-1      )
     pkg_search_module( NSPR      nspr        )
     pkg_search_module( GTK2      gtk+-2.0    )
     pkg_search_module( GLIB2     glib-2.0    )
     pkg_search_module( GDK2      gdk-x11-2.0 )
     pkg_search_module( GTHREAD   gthread-2.0 )
     pkg_search_module( GMODULE2  gmodule-2.0 )
     pkg_search_module( DBUS-GLIB dbus-glib-1 )

     if( DBUS_FOUND )
         set( HAVE_DBUS 1 )
      else()
         tde_message_fatal( "Dbus is required but dbus was not found on your system." )
     endif()

     if( NSPR_FOUND )
         set( HAVE_NSPR 1 )
      else()
         tde_message_fatal( "Nspr support has been requested but nspr was not found on your system." )
     endif()

     if( NOT GTK2_FOUND )
         tde_message_fatal( "GTK2 support is required but was not found on your system." )
     endif()

     if( NOT GLIB2_FOUND )
         tde_message_fatal( "GLIB2 support is required but was not found on your system." )
     endif()

     if( NOT GDK2_FOUND )
         tde_message_fatal( "GDK2 support is required but was not found on your system." )
     endif()

     if( NOT GTHREAD_FOUND )
         tde_message_fatal( "GTHREAD support is required but was not found on your system." )
     endif()

     if( NOT GMODULE2_FOUND )
         tde_message_fatal( "GMODULE2 support is required but was not found on your system." )
     endif()

     if( NOT DBUS-GLIB_FOUND )
         tde_message_fatal( "DBUS-GLIB support is required but was not found on your system." )
     endif()
endif( BUILD_KNPPLAYER )


##### check for xine-engine

if( BUILD_KXINEPLAYER )
    pkg_search_module( XINE libxine )
    
    if( XINE_FOUND )
        set( HAVE_XINE 1 )
     else()
       tde_message_fatal( "Xine support has been requested but libxine was not found on your system." )
    endif()
endif( BUILD_KXINEPLAYER )


##### check for gstreamer

if( BUILD_KGSTPLAYER )
    pkg_search_module( GSTREAMER gstreamer-1.0>=1.0.0 gstreamer-0.10>=0.10.0 )

    if( GSTREAMER_FOUND )
        set( HAVE_GSTREAMER 1 )
     else()
        tde_message_fatal( "Gstreamer support has been requested but gstreamer was not found on your system." )
    endif()

    if( ${GSTREAMER_VERSION} GREATER "0.11.0" )
        pkg_search_module( GSTREAMER_VIDEO gstreamer-video-1.0 )
        pkg_search_module( GSTREAMER_PLUGIN gstreamer-plugins-base-1.0 )
     else()
        pkg_search_module( GSTREAMER_VIDEO gstreamer-interfaces-0.10 )
        pkg_search_module( GSTREAMER_PLUGIN gstreamer-plugins-base-0.10 )
    endif()

    message( STATUS "gstreamer version:         ${GSTREAMER_VERSION}"        )
    message( STATUS "gstreamer video version:   ${GSTREAMER_VIDEO_VERSION}"  )
    message( STATUS "gstreamer plugins version: ${GSTREAMER_PLUGIN_VERSION}" )
endif( BUILD_KGSTPLAYER )


##### check for koffice-plugin

if( BUILD_KOFFICE_PLUGIN )

    find_path( KOFFICE_INCLUDE_DIR NAMES KoDocument.h
               HINTS
                   ${TQT_INCLUDE_DIRS}
                   ${TDE_INCLUDE_DIR}
                   ${TDE_INCLUDE_DIR}/tde
    )
    
    if( "${KOFFICE_INCLUDE_DIR}" STREQUAL "KOFFICE_INCLUDE_DIR-NOTFOUND" )
        tde_message_fatal( "KOffice plugin is requested but KOffice headers were not found on your system." )
    endif()
    
    set( HAVE_KOFFICE 1 CACHE INTERNAL "" )
    set( KOFFICE_LIBRARIES kofficecore kofficeui )
endif( BUILD_KOFFICE_PLUGIN )
