/***************************************************************************
                          kchooseimportexportdlg.cpp  -  description
                             -------------------
    begin                : Thu Jul 12 2001
    copyright            : (C) 2000-2001 by Michael Edwardes
    email                : mte@users.sourceforge.net
                             Javier Campos Morales <javi_c@users.sourceforge.net>
                             Felix Rodriguez <frodriguez@users.sourceforge.net>
                             John C <thetacoturtle@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tdeglobal.h>
#include <tdelocale.h>
#include <tdestandarddirs.h>

#include <tqpixmap.h>

#include <tqlabel.h>
#include <tqcombobox.h>
#include <tqpushbutton.h>

#include <tdeglobal.h>
#include <tdeconfig.h>
#include <tdelocale.h>

#include "kchooseimportexportdlg.h"

KChooseImportExportDlg::KChooseImportExportDlg(int type, TQWidget *parent, const char *name )
 : KChooseImportExportDlgDecl(parent,name, true)
{
  TQString filename;

  if (type==0) { // import
    topLabel->setText(i18n("Please choose the type of import you wish to perform.  A simple explanation\n"
        "of the import type is available at the bottom of the screen and is updated when\n"
        "you select an item from the choice box."
        "\n\nOnce you have chosen an import type please press the OK button." ));
    promptLabel->setText(i18n("Choose import type:"));
    setCaption(i18n("Choose Import Type Dialog"));
  } else { // export
    topLabel->setText(i18n("Please choose the type of export you wish to perform.  A simple explanation\n"
        "of the export type is available at the bottom of the screen and is updated when\n"
        "you select an item from the choice box."
        "\n\nOnce you have chosen an export type please press the OK button." ));
    promptLabel->setText(i18n("Choose export type:"));
    setCaption(i18n("Choose Export Type Dialog"));
  }

  readConfig();
  slotTypeActivated(m_lastType);
  typeCombo->setCurrentItem(((m_lastType=="QIF") ? 0 : 1));

  connect(typeCombo, TQ_SIGNAL(activated(const TQString&)), this, TQ_SLOT(slotTypeActivated(const TQString&)));
  connect(okButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(accept()));
  connect(cancelButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(reject()));
}

KChooseImportExportDlg::~KChooseImportExportDlg()
{
  writeConfig();
}

void KChooseImportExportDlg::slotTypeActivated(const TQString& text)
{
  if (text=="QIF") {
    descriptionLabel->setText(i18n("QIF files are created by the popular accounting program Quicken.\n"
      "Another dialog will appear, if you choose this type, asking for further\n"
      "information relevant to the Quicken format."));
  } else {
    descriptionLabel->setText(i18n("The CSV type uses a comma delimeted text file that can be used by\n"
      "most popular spreadsheet programs available for Linux and other operating\n"
      "systems."));
  }
}

TQString KChooseImportExportDlg::importExportType(void)
{
  return typeCombo->currentText();
}

void KChooseImportExportDlg::readConfig(void)
{
  TDEConfig *config = TDEGlobal::config();
  config->setGroup("Last Use Settings");
  m_lastType = config->readEntry("KChooseImportExportDlg_LastType");
}

void KChooseImportExportDlg::writeConfig(void)
{
  TDEConfig *config = TDEGlobal::config();
  config->setGroup("Last Use Settings");
  config->writeEntry("KChooseImportExportDlg_LastType", typeCombo->currentText());
  config->sync();
}

#include "kchooseimportexportdlg.moc"
