/***************************************************************************
                          knutprefdlg.h  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTPREFDLG_H
#define KNUTPREFDLG_H

#include "knutnewupsdlg.h"
#include "knutupsdata.h"
#include "knutvardata.h"
#include "knutconst.h"


#include <kdialogbase.h>
#include <kpushbutton.h>
#include <tdelistbox.h>
#include <tdelocale.h>
#include <tdefontdialog.h>
#include <kcolorbtn.h>
#include <kcombobox.h>

#include <tqwidget.h>

class TQLabel;
class TQFont;
class TQCheckBox;
class TQRadioButton;
class TQSpinBox;


/**
  *@author Daniel Prynych
  */

/**
 * This class makes configure dialog
 * Tato trida je vytvari konfiguracni dialog.
 * @author Daniel Prynych
 * @short Konfiguracni dialog
 * @version 0.8
 */
class KNutPrefDlg : public KDialogBase
{
  TQ_OBJECT
  
  public:

enum changePref {
  ChangeCountCols =             0x1, //1,
  ChangeCustomBColor =          0x2, //2,
  ChangeMBColor =               0x4, //4,
  ChangeVoltage =               0x8, // 8,
  ChangeFrequency =            0x10, // 16,
  ChangeXFer =                 0x20, // 32,

  ChangeUpsSetting =           0x40, // 64,
  ChangeUpsCount =             0x80, // 128,

  ChangeMainPanelSetting =    0x100, // 256,
  ChangeCustomMPanelBColor =  0x200, // 512,
  ChangeMPBColor =            0x400, // 1024,

  ChangeAnalogFont =          0x800, // 2048,
  ChangePanelFont =          0x1000, // 4096,

  ChangeCustomAPanelBColor = 0x2000, // 8192,
  ChangeAPBColor =           0x4000, // 16384,

  ChangeCustomAPanelOColor = 0x8000, // 32768,
  ChangeAPOColor =          0x10000, // 65536,

  ChangeCustomTDEIconColor =  0x20000, // 131072,
  ChangeTDEIconBColor =       0x40000, // 262144,

  ChangeToolTip =           0x80000, // 524288,

  ChangeTypeOfTDEIcon =      0x100000,  // 1048576

  ChangeTypeOfDigProcessing =      0x200000,  // 1048576 *2

  ChangeSomeThing =        0x400000  // 1048576 *4


  };




/**
 * Constructor makes configure dialog.
 * Konstruktor vytvori konfiguracni dialog.
 *
 * @param upsData Is pointer on instance of class of KNutUpsData,  which manage informations about UPSes.
 * @param analogData Is pointer on instance of class of KNutVarData, which manages data about analog panels.
 * @param settingData Is pointer on struct, which contain values is setted in dialog.
 * @param upsName Is name of active UPS.
 *
 * @param upsData Je odkaz na instanci tridy KNutUpsData, ktera spravuje informace o UPS-kach.
 * @param analogData Je odkaz na na instanci tridy KNutVarData, ktera spravuje data o analogovych panelech.
 * @param settingData Je odkaz na strukturu ktera obsahuje hodnoty nastavovane v dialogu.
 * @param upsName Je jmeno aktivni UPS-ky.
 *
 * @since  0.5
 **/
  KNutPrefDlg(KNutUpsData* const upsData, KNutVarData* const analogData, KNutVarData::SettingDataDef* const settingData, const TQString upsName, TQWidget* parent = 0, const char* name = 0, const bool modal = true);

/**
 * @since  0.3
 **/
  ~KNutPrefDlg();

  signals:

/**
 * Signal is emited when statement is changed same pages.
 * Signal je aktivovan pokud je zmenen udaj na kterekoliv strance.
 *
 * @param changeSetting Declare, what item was changed.
 * @param changeSetting Udava, ktery prvek byl zmenen.
 *
 * @since  0.2
 **/
  void signalChangeConfig (unsigned int changeSetting );



  private slots:

/**
 * @internal
 */
  virtual void slotDefault();

/**
 * @internal
 */
  virtual void slotApply();

/**
 * @internal
 */
  virtual void slotOk();

/**
 * @internal
 */
  void slotChangeSettingFont(int index);

/**
 * @internal
 */
  void slotSetPictureKI (bool on);


/**
 * @internal
 */
  void slotEnableVoltage(bool enable);


/**
 * @internal
 */
  void slotEnableFrequency(bool enable);


/**
 * @internal
 */
  void slotUseCustomBColor(bool enable);

/**
 * @internal
 */
  void slotUseCustomBPanelColor(bool enable);

/**
 * @internal
 */
void slotUseCustomBAnalogColor(bool enable);


/**
 * @internal
 */
void slotUseCustomOAnalogColor(bool enable);

/**
 * @internal
 */
void slotUseCustomBIconColor(bool enable);

  
/**
 * @internal
 */
  void slotNewUps();

/**
 * @internal
 */
  void slotEditUps();

/**
 * @internal
 */
  void slotDeleteUps();


  private:

  enum Page {
    mainSettingPage =0,
    upsSettingPage,
    panelSettingPage,
    fontSettingPage,
    analogSettingPage,
    kickerSettingPage
    };

/**
 * @internal
 */
  void initSetting();

/**
 * @internal
 */
  void initUps();

/**
 * @internal
 */
  void initPanel();

/**
 * @internal
 */
  void initFonts();

/**
 * @internal
 */
  void initAnalog ();

/**
 * @internal
 */
  void initDock ();



// Private values
  TQString m_activeUpsName; // name of UPS which is active
  KNutUpsData* m_myUpsData;
  KNutVarData* m_myAnalogData;
  KNutVarData::SettingDataDef* m_settingData;
  KNutNewUpsDlg* newUpsDlg;

  TDEListBox* m_listBox2; // uses in part UPS, contain name of UPS

  bool m_checked; //it's settted when, definition(parameters) of UPS were chaged // nastaveno kdyz doslo k zmene v definici UPS
  bool m_checkedActiveUps; //it's setted when, parameters of active UPS were changed // nastaveno pokud doslo ke zmene na aktivni UPS

  TQSpinBox *m_numberOfColumns;
  KColorButton *m_BGButton;
  TQCheckBox *m_checkBoxCbc;
  TQCheckBox *m_checkBoxAys;
//  TQCheckBox *m_checkBoxMW;
  TQCheckBox *m_checkBoxMesW;
  KComboBox *m_comboBoxMainWindow;
  TQCheckBox *m_xfer;

  TQCheckBox *m_checkBoxOver;
  TQCheckBox *m_checkBoxBL;
  TQCheckBox *m_checkBoxRB;
  TQCheckBox *m_checkBoxCal;
  TQCheckBox *m_checkBoxMFRM;
  TQCheckBox *m_checkBoxMFR;
  TQCheckBox *m_checkBoxModel;
  TQCheckBox *m_checkBoxSerial;
  TQCheckBox *m_checkBoxFirm;
  TQCheckBox *m_checkBoxRun;
  TQCheckBox *m_checkBoxCbpc;
  TQCheckBox* m_checkBoxCbac;
  TQCheckBox* m_checkBoxCoac;
  TQCheckBox *m_checkBoxCbi;
  TQCheckBox *m_checkBoxTTMFR;
  TQCheckBox *m_checkBoxTTModel;
  TQCheckBox *m_checkBoxTTSerial;
  TQCheckBox *m_checkBoxTTFirm;
  TQCheckBox *m_checkBoxTTRun;
  TQCheckBox *m_checkBoxTTCharge;
  TQCheckBox *m_checkBoxTTLoad;

  TQLabel *m_panelBackgroundColorLabel;
  TQLabel *m_mainBackgroundColorLabel;
  TQLabel *m_analogBackgroundColorLabel;
  TQLabel *m_dockBackgroundColorLabel;
  TQLabel *m_analogPointerColorLabel;
  TQLabel *m_analogOKColorLabel;
  TQLabel *m_analogWarningColorLabel;
  TQLabel *m_analogErrorColorLabel;
  TQLabel *m_analogScaleColorLabel;
  TQLabel *m_analogFontColorLabel;
  TQLabel *m_digitalProcessingLabel;
  TQLabel *m_iconDockLabel;

  TQRadioButton *m_vRadioButton1;
  TQRadioButton *m_vRadioButton2;
  TQRadioButton *m_fRadioButton1;
  TQRadioButton *m_fRadioButton2;
  TQRadioButton *m_iconRadioButton1;
  TQRadioButton *m_iconRadioButton2;

  KColorButton *m_BGPButton;
  KColorButton* m_BGAButton;
  KColorButton* m_AFingerButton;
  KColorButton* m_AOKButton;
  KColorButton* m_AWarnningButton;
  KColorButton* m_AErrorButton;
  KColorButton* m_AScaleButton;
  KColorButton* m_AFontButton;
  KColorButton *m_BGIButton;

  KComboBox* m_digitalProcesingOfPointers;

  TQButtonGroup	*m_voltageGroup;
  TQButtonGroup	*m_frequencyGroup;

  TQCheckBox* m_customFont; // User's font 
  TDEFontChooser *m_fontWidget;

  TQFont m_aPanelFont; // Analog panel font
  TQFont m_mPanelFont; // Main panel font

  int m_settingFont; // which font is setted (selected)

  TQPixmap m_panelPix;
  TQPixmap m_mSetPix;
  TQPixmap m_upsesPix;
  TQPixmap m_analogPix;
  TQPixmap m_dockPix;

};

#endif
