/* This file is part of the KDE project
   Copyright (C) 2003 Lucijan Busch <lucijan@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include <tqlistview.h>
#include <tqpushbutton.h>
#include <tqlayout.h>
#include <tqheader.h>
#include <tqstringlist.h>

#include "kexiproject.h"
#include "kexiprojecthandler.h"
#include "kexiprojecthandleritem.h"
#include "kexidataprovider.h"
#include "kexifilterdlg.h"
#include "kexiquerydesignersqleditor.h"

KexiFilterDlg::KexiFilterDlg(KexiProject *project, TQWidget *parent, const char *name)
 : TQDialog(parent, name)
{
	m_project = project;

	TQHBoxLayout *lbraces = new TQHBoxLayout(0, 0, 4);

	TQPushButton *bsBO = createMiniButton("[");
	TQPushButton *bBO = createMiniButton("(");
	TQPushButton *bBC = createMiniButton(")");
	TQPushButton *bsBC = createMiniButton("]");
	lbraces->addWidget(bsBO);
	lbraces->addWidget(bBO);
	lbraces->addWidget(bBC);
	lbraces->addWidget(bsBC);

	TQHBoxLayout *lcond = new TQHBoxLayout(0, 0, 4);
	TQPushButton *blt = createMiniButton("<");
	TQPushButton *beq = createMiniButton("=");
	TQPushButton *bgt = createMiniButton(">");
	TQPushButton *bp = createMiniButton("%");
	lcond->addWidget(blt);
	lcond->addWidget(beq);
	lcond->addWidget(bgt);
	lcond->addWidget(bp);

	TQHBoxLayout *lbool = new TQHBoxLayout(0, 0, 4);
	TQPushButton *bAnd = new TQPushButton("AND", this);
	bAnd->setFlat(true);
	TQPushButton *bOr = new TQPushButton("OR", this);
	bOr->setFlat(true);
	TQPushButton *bLike = new TQPushButton("LIKE", this);
	bLike->setFlat(true);
	lbool->addWidget(bLike);
	lbool->addWidget(bAnd);
	lbool->addWidget(bOr);

	m_catalog = new TQListView(this);
	m_catalog->addColumn("a");
	m_catalog->header()->hide();

	KexiQueryDesignerSQLEditor *e = new KexiQueryDesignerSQLEditor(this);

	setupCatalog(TQString("kexi/table"));

	TQGridLayout *g = new TQGridLayout(this);
	g->setSpacing(6);
	g->addMultiCellWidget(e,		0, 0, 0, 2);
	g->addItem(lbraces,			1, 0);
	g->addItem(lcond,			1, 1);
	g->addItem(lbool,			1, 2);
	g->addMultiCellWidget(m_catalog,	2, 2, 0, 2);
}

TQPushButton*
KexiFilterDlg::createMiniButton(const TQString &text)
{
	TQPushButton *p = new TQPushButton(text, this);
	p->setFlat(true);
	p->setMaximumSize(TQSize(20, 300));

	return p;
}

void
KexiFilterDlg::setupCatalog(const TQStringList &mimes)
{
	m_catalog->clear();
	m_catalog->setRootIsDecorated(true);
	TQStringList::ConstIterator it, end( mimes.constEnd() );
	for( it = mimes.constBegin(); it != end; ++it)
	{
		KexiProjectHandler *h = m_project->handlerForMime(*it);
		if(h)
		{
			TQListViewItem *base = new TQListViewItem(m_catalog, h->name());
			base->setPixmap(0, h->groupPixmap());

			TQDictIterator<KexiProjectHandlerItem> iit(*h->items()); // See TQDictIterator
			for(; iit.current(); ++iit )
			{
				TQListViewItem *bi = new TQListViewItem(base, iit.current()->name());
				bi->setPixmap(0, h->itemPixmap());

				KexiDataProvider *prov=KEXIDATAPROVIDER(h);
				if(prov)
				{
					TQStringList fields = prov->fields(0, iit.current()->identifier());
					TQStringList::ConstIterator fit, end( fields.constEnd() );
					for( fit = fields.constBegin(); fit != end; ++fit)
					{
						TQListViewItem *bif = new TQListViewItem(bi, (*fit));
					}
				}
			}
		}
	}
}

void
KexiFilterDlg::setupCatalog(const TQString &mime)
{
	TQStringList l;
	l.append(mime);
	setupCatalog(l);
}

void
KexiFilterDlg::insert(TQListViewItem *)
{
}

KexiFilterDlg::~KexiFilterDlg()
{
}

#include "kexifilterdlg.moc"
