/* This file is part of the KDE project
   Copyright (C) 2004 Cedric Pasteur <cedric.pasteur@free.fr>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KFORMDESIGNEREVENTS_H
#define KFORMDESIGNEREVENTS_H

#include <tqptrlist.h>
#include <tqstring.h>

class TQDomNode;

namespace KFormDesigner {

class KFORMEDITOR_EXPORT Connection
{
	public:
		Connection(const TQString &sender, const TQString &signal,
			const TQString &receiver, const TQString &slot);
		Connection() {;}
		~Connection() {;}

		TQString	sender() const { return m_sender; }
		TQString	receiver() const { return m_receiver; }
		TQString	signal() const { return m_signal; }
		TQString	slot() const { return m_slot; }

		void	setSender(const TQString &v) { m_sender = v; }
		void	setReceiver(const TQString &v) { m_receiver = v; }
		void	setSignal(const TQString &v) { m_signal = v; }
		void	setSlot(const TQString &v) { m_slot = v; }

	protected:
		TQString m_sender;
		TQString m_signal;
		TQString m_receiver;
		TQString m_slot;
};

typedef TQPtrList<Connection> ConnectionList;

class KFORMEDITOR_EXPORT ConnectionBuffer : public ConnectionList
{
	public:
		ConnectionBuffer();
		~ConnectionBuffer() {;}

		void save(TQDomNode &parentNode);
		void load(TQDomNode parentNode);

		/*! This function is called when a widget is renamed from \a oldname
		to \a newname. All the Connections for this widget are updated. */
		void    fixName(const TQString &oldname, const TQString &newName);

		ConnectionBuffer*     allConnectionsForWidget(const TQString &widget);
		void     saveAllConnectionsForWidget(const TQString &widget, TQDomNode parentNode);
		void     removeAllConnectionsForWidget(const TQString &widget);
};

}

#endif

