/*
    Copyright (C) 2000, S.R.Haque <shaheedhaque@hotmail.com>.
    This file is part of the KDE project

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

DESCRIPTION
*/

#ifndef PPTXML_H
#define PPTXML_H

#include <pptdoc.h>
#include <tqobject.h>
#include <tqstring.h>

#define ALIGN_LEFT 		1
#define ALIGN_RIGHT 	2
#define ALIGN_CENTER 	4
#define ALIGN_JUSTIFY 	8

class myFile;
class TQDomDocument;

class PptXml:
    public TQObject,
    private PptDoc
{

    TQ_OBJECT
  

public:
    PptXml(
        const myFile &mainStream,
        const myFile &currentUser,
        const myFile &pictures);
    ~PptXml();

    bool convert();

    const TQString getXml() const;

signals:
    // See olefilter.h for information
    void signalSavePic(
        const TQString &nameIN,
        TQString &storageId,
        const TQString &extension,
        unsigned int length,
        const char *data);

    void signalSavePart(
        const TQString &nameIN,
        TQString &storageId,
        TQString &mimeType,
        const TQString &extension,
        unsigned int length,
        const char *data);

    void signalPart(
        const TQString& nameIN,
        TQString &storageId,
        TQString &mimeType);

private:
    PptXml(const PptXml &);
    const PptXml &operator=(const PptXml &);

    // Error handling and reporting support.

    static const int s_area;

    // The conversion is done exactly once. Has it already happened?

    bool m_isConverted;
    bool m_success;
    bool m_half;
    unsigned m_y;
    TQString m_embedded;
    TQString m_pages;
    TQString m_titles;
    TQString m_notes;
    TQString m_text;
    void encode(TQString &text);

    // Override the base class functions.

    void gotDrawing(
        unsigned id,
        TQString type,
        unsigned length,
        const char *data);
    void gotSlide(PptSlide &slide);
    void setPlaceholder(PptSlide &slide);
};
#endif
