/* This file is part of the KDE project
   Copyright 2004 Ariya Hidayat <ariya@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KSPREAD_TESTER
#define KSPREAD_TESTER

#include <tqstring.h>
#include <tqstringlist.h>

namespace KSpread
{

class Tester
{
public:
  Tester();
  virtual ~Tester() {;};

public:
  virtual TQString name() = 0;
  virtual void run() = 0;
  unsigned count() const;
  unsigned failed() const;
  TQStringList errors() const;

protected:
  void fail( const char *file, int line, const TQString& msg );
  int testCount;
  TQStringList errorList;
};

}

#endif // KSPREAD_TESTER
