/*
 * Kivio - Visual Modelling and Flowcharting
 * Copyright (C) 2000-2001 theKompany.com & Dave Marotti
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef KIVIO_STENCIL_SPAWNER_SET_H
#define KIVIO_STENCIL_SPAWNER_SET_H

#include <tqptrlist.h>
#include <tqdom.h>

class KivioStencilSpawner;
class TQStringList;

class KivioStencilSpawnerSet
{
  protected:
    TQString m_dir;
    TQString m_name;
    TQString m_id;

    TQStringList m_files;

    TQPtrList<KivioStencilSpawner> *m_pSpawners;
    KivioStencilSpawner *m_pSelected;

    bool m_hidden;

  public:
    KivioStencilSpawnerSet(const TQString& name=TQString());
    virtual ~KivioStencilSpawnerSet();

    bool loadDir( const TQString & );
    KivioStencilSpawner* loadFile( const TQString & );

    bool loadXML( const TQDomElement & );
    TQDomElement saveXML( TQDomDocument & );

    TQPtrList<KivioStencilSpawner> *spawners() { return m_pSpawners; }
    KivioStencilSpawner *selected() { return m_pSelected; }

    TQString dir() { return m_dir; }
    TQString name() { return m_name; }
    TQString id() { return m_id; }

    void setDir( const TQString &s ) { m_dir=s; }
    void setName( const TQString &s ) { m_name=s; }
    void setId( const TQString &s ) { m_id=s; }

    KivioStencilSpawner *spawnerAt( int i ) { return m_pSpawners->at(i); }
    KivioStencilSpawner *find( const TQString& );

    int count() { return m_pSpawners->count(); }

    static TQString readTitle( const TQString & );
    static TQString readId( const TQString & );
    static TQString readDescription(const TQString&);

    TQStringList files() const { return m_files; }

    void addSpawner(KivioStencilSpawner* spawner);

    void setHidden(bool hide) { m_hidden = hide; }
    bool hidden() const { return m_hidden; }
};

#endif


