/* This file is part of the KDE project
   Copyright (C) 2002-2003 Ariya Hidayat <ariya@kde.org>
             (C) 2001-2003 Laurent Montel <montel@kde.org>
             (C) 1998, 1999 Torben Weis <weis@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __kspread_dlg_list__
#define __kspread_dlg_list__

#include <kdialogbase.h>

class TQListBox;
class TQListBoxItem;
class TQLineEdit;
class TQMultiLineEdit;
class TQPushButton;

class TDEConfig;

namespace KSpread
{

class ListDialog: public KDialogBase
{
  TQ_OBJECT
  

public:
  ListDialog( TQWidget* parent, const char* name );
  void init();

public slots:
  virtual void slotOk();
  void slotDoubleClicked(TQListBoxItem *);
  void slotTextClicked(TQListBoxItem*);
  void slotRemove();
  void slotAdd();
  void slotNew();
  void slotModify();
  void slotCopy();

protected:
  TDEConfig *config;

  TQListBox * list;
  TQMultiLineEdit *entryList;
  TQPushButton* m_pRemove;
  TQPushButton* m_pNew;
  TQPushButton* m_pAdd;
  TQPushButton* m_pModify;
  TQPushButton* m_pCopy;
  bool m_bChanged;
};

} // namespace KSpread

#endif
