/***************************************************************************
*   Copyright (C) 2004 by Alexander Dymo                                  *
*   cloudtemple@mskat.net                                                 *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU Library General Public License as       *
*   published by the Free Software Foundation; either version 2 of the    *
*   License, or (at your option) any later version.                       *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU Library General Public     *
*   License along with this program; if not, write to the                 *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.             *
***************************************************************************/
#include "propertyserializer.h"

#include <tqcolor.h>
#include <tqfont.h>

#include <kdebug.h>

namespace Kudesigner
{

PropertySerializer::PropertySerializer()
{}

PropertySerializer::~PropertySerializer()
{}

TQString PropertySerializer::toString( Property *prop )
{
    TQVariant val = prop->value();
    switch ( prop->type() )
    {
    case KoProperty::Color:
        return TQString( "%1,%2,%3" ).arg( val.toColor().red() ).arg( val.toColor().green() ).arg( val.toColor().blue() );
    case KoProperty::Boolean:
        return val.toBool() ? "true" : "false";
    case KoProperty::Font:
        return val.toFont().family();
    default:
        return val.toString();
    }
}

TQVariant PropertySerializer::fromString( Property *prop, const TQString &str )
{
    switch ( prop->type() )
    {
    case KoProperty::Color:
        return TQVariant( TQColor( str.section( ',', 0, 0 ).toInt(),
                                 str.section( ',', 1, 1 ).toInt(),
                                 str.section( ',', 2, 2 ).toInt() ) );
    case KoProperty::Integer:
        return TQVariant( str.toInt() );
    case KoProperty::Boolean:
        return TQVariant( str == "true" );
    case KoProperty::Font:
        return TQVariant( TQFont( str ) );
    case KoProperty::LineStyle:
        return TQVariant( str.toInt() );
    case KoProperty::Symbol:
        return TQVariant( str.at( 0 ).latin1() );
    default:
        return TQVariant( str );
    }
}

}
